/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.chain;

import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.ChainedComponent;
import com.yahoo.component.chain.Phase;
import com.yahoo.component.chain.dependencies.ordering.ChainBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Chain<COMPONENT extends ChainedComponent> {
    private final List<COMPONENT> componentList;
    private final ComponentId id;

    public Chain(String id, List<COMPONENT> componentList) {
        this(new ComponentId(id), componentList);
    }

    public Chain(ComponentId id, List<COMPONENT> componentList) {
        this.id = id;
        this.componentList = List.copyOf(componentList);
    }

    public Chain(List<COMPONENT> componentList) {
        this(new ComponentId("anonymous chain"), componentList);
    }

    @SafeVarargs
    public Chain(COMPONENT ... components) {
        this("anonymous chain", (ChainedComponent[])components);
    }

    @SafeVarargs
    public Chain(String id, COMPONENT ... components) {
        this(new ComponentId(id), (ChainedComponent[])components);
    }

    @SafeVarargs
    public Chain(ComponentId id, COMPONENT ... components) {
        this(id, Arrays.asList(components));
    }

    public Chain(ComponentId id, Collection<COMPONENT> components, Collection<Phase> phases) {
        this(id, Chain.buildChain(Chain.emptyListIfNull(components), Chain.emptyListIfNull(phases)).components());
    }

    public ComponentId getId() {
        return this.id;
    }

    private static <T> Collection<T> emptyListIfNull(Collection<T> collection) {
        return collection == null ? Collections.emptyList() : collection;
    }

    private static <T extends ChainedComponent> Chain<T> buildChain(Collection<T> components, Collection<Phase> phases) {
        ChainBuilder builder = new ChainBuilder(new ComponentId("temp"));
        for (Phase phase : phases) {
            builder.addPhase(phase);
        }
        for (ChainedComponent component : components) {
            builder.addComponent(component);
        }
        return builder.orderNodes();
    }

    public List<COMPONENT> components() {
        return this.componentList;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("chain '");
        b.append(this.getId().stringValue());
        b.append("' [");
        this.appendComponent(0, b);
        this.appendComponent(1, b);
        if (this.components().size() > 3) {
            b.append("... -> ");
        }
        if (this.components().size() > 2) {
            this.appendComponent(this.components().size() - 1, b);
        }
        b.append("]");
        return b.toString();
    }

    private void appendComponent(int i, StringBuilder b) {
        if (i >= this.components().size()) {
            return;
        }
        b.append(((ChainedComponent)((Object)this.components().get(i))).getId().stringValue());
        if (i < this.components().size() - 1) {
            b.append(" -> ");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chain chain = (Chain)o;
        if (!this.componentList.equals(chain.componentList)) {
            return false;
        }
        return this.id.equals((Object)chain.id);
    }

    public int hashCode() {
        int result = this.componentList.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }
}

