/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.server.jetty.RequestException;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import com.yahoo.jdisc.service.CurrentContainer;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Utf8Appendable;

class HttpRequestFactory {
    HttpRequestFactory() {
    }

    public static HttpRequest newJDiscRequest(CurrentContainer container, HttpServletRequest servletRequest) {
        try {
            HttpRequest httpRequest = HttpRequest.newServerRequest(container, HttpRequestFactory.getUri(servletRequest), HttpRequestFactory.getMethod(servletRequest), HttpRequest.Version.fromString(servletRequest.getProtocol()), new InetSocketAddress(servletRequest.getRemoteAddr(), servletRequest.getRemotePort()), RequestUtils.getConnection((Request)servletRequest).getCreatedTimeStamp());
            httpRequest.context().put("jdisc.request.X509Certificate", HttpRequestFactory.getCertChain(servletRequest));
            httpRequest.context().put("jdisc.request.port", servletRequest.getLocalPort());
            SSLSession sslSession = (SSLSession)servletRequest.getAttribute(RequestUtils.JETTY_REQUEST_SSLSESSION);
            httpRequest.context().put("jdisc.request.SSLSession", sslSession);
            servletRequest.setAttribute(HttpRequest.class.getName(), (Object)httpRequest);
            return httpRequest;
        }
        catch (Utf8Appendable.NotUtf8Exception e) {
            throw HttpRequestFactory.createBadQueryException((IllegalArgumentException)((Object)e));
        }
    }

    private static HttpRequest.Method getMethod(HttpServletRequest servletRequest) {
        String method = servletRequest.getMethod();
        try {
            return HttpRequest.Method.valueOf(method);
        }
        catch (IllegalArgumentException e) {
            throw new RequestException(405, "Invalid method '" + method + "'");
        }
    }

    public static URI getUri(HttpServletRequest servletRequest) {
        try {
            String scheme = servletRequest.getScheme();
            String host = servletRequest.getServerName();
            int port = RequestUtils.getConnectorLocalPort((Request)servletRequest);
            String path = servletRequest.getRequestURI();
            String query = servletRequest.getQueryString();
            URI uri = URI.create(scheme + "://" + host + ":" + port + (path != null ? path : "") + (String)(query != null ? "?" + query : ""));
            HttpRequestFactory.validateSchemeHostPort(scheme, host, port, uri);
            return uri;
        }
        catch (IllegalArgumentException e) {
            throw HttpRequestFactory.createBadQueryException(e);
        }
    }

    private static void validateSchemeHostPort(String scheme, String host, int port, URI uri) {
        if (!scheme.equals(uri.getScheme())) {
            throw new IllegalArgumentException("Bad scheme: " + scheme);
        }
        if (!host.equals(uri.getHost()) || port != uri.getPort()) {
            throw new IllegalArgumentException("Bad authority: " + uri.getRawAuthority() + " != " + host + ":" + port);
        }
    }

    private static RequestException createBadQueryException(IllegalArgumentException e) {
        return new RequestException(400, "URL violates RFC 2396: " + e.getMessage(), e);
    }

    public static void copyHeaders(HttpServletRequest from, HttpRequest to) {
        Enumeration it = from.getHeaderNames();
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            Enumeration value = from.getHeaders(key);
            while (value.hasMoreElements()) {
                to.headers().add(key, (String)value.nextElement());
            }
        }
    }

    private static X509Certificate[] getCertChain(HttpServletRequest servletRequest) {
        return (X509Certificate[])servletRequest.getAttribute("jakarta.servlet.request.X509Certificate");
    }
}

