/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.container.jdisc.ContentChannelOutputStream;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class MaxPendingContentChannelOutputStream
extends ContentChannelOutputStream {
    private final long maxPending;
    private final AtomicLong sent = new AtomicLong(0L);
    private final AtomicLong acked = new AtomicLong(0L);

    public MaxPendingContentChannelOutputStream(ContentChannel endpoint, long maxPending) {
        super(endpoint);
        this.maxPending = maxPending;
    }

    private long pendingBytes() {
        return this.sent.get() - this.acked.get();
    }

    @Override
    public void send(ByteBuffer src) throws IOException {
        try {
            this.stallWhilePendingAbove(this.maxPending);
        }
        catch (InterruptedException ignored) {
            throw new InterruptedIOException("Interrupted waiting for IO");
        }
        TrackCompletion pendingTracker = new TrackCompletion(src.remaining());
        try {
            this.send(src, pendingTracker);
        }
        catch (Throwable throwable) {
            pendingTracker.failed(throwable);
            throw throwable;
        }
    }

    private void stallWhilePendingAbove(long pending) throws InterruptedException {
        while (this.pendingBytes() > pending) {
            Thread.sleep(1L);
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        try {
            this.stallWhilePendingAbove(0L);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted waiting for IO");
        }
    }

    private class TrackCompletion
    implements CompletionHandler {
        private final long written;
        private final AtomicBoolean replied = new AtomicBoolean(false);

        TrackCompletion(long written) {
            this.written = written;
            MaxPendingContentChannelOutputStream.this.sent.addAndGet(written);
        }

        public void completed() {
            if (!this.replied.getAndSet(true)) {
                MaxPendingContentChannelOutputStream.this.acked.addAndGet(this.written);
            }
        }

        public void failed(Throwable t) {
            if (!this.replied.getAndSet(true)) {
                MaxPendingContentChannelOutputStream.this.acked.addAndGet(this.written);
            }
        }
    }
}

