/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.metrics;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.container.handler.metrics.ErrorResponse;
import com.yahoo.container.handler.metrics.JsonResponse;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.RequestView;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.container.jdisc.utils.CapabilityRequiringRequestHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.restapi.Path;
import com.yahoo.security.tls.Capability;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public abstract class HttpHandlerBase
extends ThreadedHttpRequestHandler
implements CapabilityRequiringRequestHandler {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private final Duration defaultTimeout;

    protected HttpHandlerBase(Executor executor) {
        this(executor, Duration.ofSeconds(25L));
    }

    protected HttpHandlerBase(Executor executor, Duration defaultTimeout) {
        super(executor);
        this.defaultTimeout = defaultTimeout;
    }

    protected abstract Optional<HttpResponse> doHandle(URI var1, Path var2, String var3);

    @Override
    public Capability requiredCapability(RequestView __) {
        return Capability.METRICSPROXY__METRICS_API;
    }

    @Override
    public Duration getTimeout() {
        return this.defaultTimeout;
    }

    @Override
    public final HttpResponse handle(HttpRequest request) {
        if (request.getMethod() != HttpRequest.Method.GET) {
            return new JsonResponse(405, "Only GET is supported");
        }
        Path path = new Path(request.getUri());
        return this.doHandle(request.getUri(), path, this.getConsumer(request)).orElse(new ErrorResponse(404, "No content at given path"));
    }

    private String getConsumer(HttpRequest request) {
        return request.getProperty("consumer");
    }

    protected JsonResponse resourceListResponse(URI requestUri, List<String> resources) {
        try {
            return new JsonResponse(200, HttpHandlerBase.resourceList(requestUri, resources));
        }
        catch (JsonProcessingException e) {
            this.log.log(Level.WARNING, "Bad JSON construction in generated resource list for " + requestUri.getPath(), e);
            return new ErrorResponse(500, "An error occurred when generating the list of api resources.");
        }
    }

    private static String resourceList(URI requestUri, List<String> resources) throws JsonProcessingException {
        int port = requestUri.getPort();
        String host = requestUri.getHost();
        StringBuilder base = new StringBuilder("http://");
        base.append(host);
        if (port >= 0) {
            base.append(":").append(port);
        }
        String uriBase = base.toString();
        ArrayNode linkList = jsonMapper.createArrayNode();
        for (String api : resources) {
            ObjectNode resource = jsonMapper.createObjectNode();
            resource.put("url", uriBase + api);
            linkList.add((JsonNode)resource);
        }
        return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonMapper.createObjectNode().set("resources", (JsonNode)linkList));
    }
}

