/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http;

import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.http.Cookie;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CookieHelper {
    private CookieHelper() {
    }

    public static List<Cookie> decodeSetCookieHeader(HeaderFields headers) {
        List cookies = headers.get((Object)"Set-Cookie");
        if (cookies == null) {
            return Collections.emptyList();
        }
        LinkedList<Cookie> ret = new LinkedList<Cookie>();
        for (String cookie : cookies) {
            ret.add(Cookie.fromSetCookieHeader(cookie));
        }
        return ret;
    }

    public static void encodeSetCookieHeader(HeaderFields headers, List<Cookie> cookies) {
        headers.remove((Object)"Set-Cookie");
        for (Cookie cookie : cookies) {
            headers.add("Set-Cookie", Cookie.toSetCookieHeaders(Arrays.asList(cookie)));
        }
    }
}

