/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.NoopSharedResource;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.FastContentWriter;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.filter.RequestFilter;
import com.yahoo.jdisc.http.filter.ResponseFilter;
import com.yahoo.jdisc.http.server.jetty.FilterBindings;
import com.yahoo.jdisc.http.server.jetty.MetricDefinitions;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jetty.server.Request;

class FilterResolver {
    private final FilterBindings bindings;
    private final Metric metric;
    private final boolean strictFiltering;

    FilterResolver(FilterBindings bindings, Metric metric, boolean strictFiltering) {
        this.bindings = bindings;
        this.metric = metric;
        this.strictFiltering = strictFiltering;
    }

    Optional<RequestFilter> resolveRequestFilter(Request request, URI jdiscUri) {
        Optional<String> maybeFilterId = this.bindings.resolveRequestFilter(jdiscUri, RequestUtils.getConnector(request).listenPort());
        if (maybeFilterId.isPresent()) {
            this.metric.add(MetricDefinitions.FILTERING_REQUEST_HANDLED, (Number)1L, this.createMetricContext(request, maybeFilterId.get()));
            request.setAttribute("jdisc.request.chain", (Object)maybeFilterId.get());
        } else if (!this.strictFiltering) {
            this.metric.add(MetricDefinitions.FILTERING_REQUEST_UNHANDLED, (Number)1L, this.createMetricContext(request, null));
        } else {
            String syntheticFilterId = "strict-reject";
            this.metric.add(MetricDefinitions.FILTERING_REQUEST_HANDLED, (Number)1L, this.createMetricContext(request, syntheticFilterId));
            request.setAttribute("jdisc.request.chain", (Object)syntheticFilterId);
            return Optional.of(RejectingRequestFilter.INSTANCE);
        }
        return maybeFilterId.map(this.bindings::getRequestFilter);
    }

    Optional<ResponseFilter> resolveResponseFilter(Request request, URI jdiscUri) {
        Optional<String> maybeFilterId = this.bindings.resolveResponseFilter(jdiscUri, RequestUtils.getConnector(request).listenPort());
        if (maybeFilterId.isPresent()) {
            this.metric.add(MetricDefinitions.FILTERING_RESPONSE_HANDLED, (Number)1L, this.createMetricContext(request, maybeFilterId.get()));
            request.setAttribute("jdisc.response.chain", (Object)maybeFilterId.get());
        } else {
            this.metric.add(MetricDefinitions.FILTERING_RESPONSE_UNHANDLED, (Number)1L, this.createMetricContext(request, null));
        }
        return maybeFilterId.map(this.bindings::getResponseFilter);
    }

    private Metric.Context createMetricContext(Request request, String filterId) {
        Map<String, String> extraDimensions = filterId != null ? Map.of("chainId", filterId) : Map.of();
        return RequestUtils.getConnector(request).createRequestMetricContext((HttpServletRequest)request, extraDimensions);
    }

    private static class RejectingRequestFilter
    extends NoopSharedResource
    implements RequestFilter {
        private static final RejectingRequestFilter INSTANCE = new RejectingRequestFilter();
        private static final String SYNTHETIC_FILTER_CHAIN_ID = "strict-reject";

        private RejectingRequestFilter() {
        }

        @Override
        public void filter(HttpRequest request, ResponseHandler handler) {
            Response response = new Response(403);
            response.headers().add("Content-Type", "text/plain");
            try (FastContentWriter writer = ResponseDispatch.newInstance((Response)response, (ByteBuffer[])new ByteBuffer[0]).connectFastWriter(handler);){
                writer.write("Request did not match any request filter chain");
            }
        }
    }
}

