/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.config;

import com.yahoo.config.FileReference;
import com.yahoo.container.core.config.BundleStarter;
import com.yahoo.container.core.config.FileAcquirerBundleInstaller;
import com.yahoo.container.di.Osgi;
import com.yahoo.jdisc.application.BsnVersion;
import com.yahoo.osgi.Osgi;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class ApplicationBundleLoader {
    private static final Logger log = Logger.getLogger(ApplicationBundleLoader.class.getName());
    private final Map<FileReference, Bundle> activeBundles = new LinkedHashMap<FileReference, Bundle>();
    private Map<FileReference, Bundle> obsoleteBundles = Map.of();
    private Map<FileReference, Bundle> bundlesFromNewGeneration = Map.of();
    private boolean readyForNewBundles = true;
    private final Osgi osgi;
    private final FileAcquirerBundleInstaller bundleInstaller;

    public ApplicationBundleLoader(Osgi osgi, FileAcquirerBundleInstaller bundleInstaller) {
        this.osgi = osgi;
        this.bundleInstaller = bundleInstaller;
    }

    public synchronized List<BsnVersion> activeBundlesBsnVersion() {
        return this.activeBundles.values().stream().map(BsnVersion::new).toList();
    }

    public synchronized void useBundles(List<FileReference> newFileReferences) {
        if (!this.readyForNewBundles) {
            throw new IllegalStateException("Bundles must be committed or reverted before using new bundles.");
        }
        this.obsoleteBundles = this.removeObsoleteReferences(newFileReferences);
        this.osgi.allowDuplicateBundles(this.obsoleteBundles.values());
        this.bundlesFromNewGeneration = this.installBundles(newFileReferences);
        BundleStarter.startBundles(this.activeBundles.values());
        log.info(this.installedBundlesMessage());
        this.readyForNewBundles = false;
    }

    public synchronized Set<Bundle> completeGeneration(Osgi.GenerationStatus status) {
        Set<Bundle> ret = Set.of();
        if (this.readyForNewBundles) {
            return ret;
        }
        this.readyForNewBundles = true;
        if (status == Osgi.GenerationStatus.SUCCESS) {
            return this.commitBundles();
        }
        return this.revertToPreviousGeneration();
    }

    private Set<Bundle> commitBundles() {
        LinkedHashSet<Bundle> bundlesToUninstall = new LinkedHashSet<Bundle>(this.obsoleteBundles.values());
        log.info("Bundles to be uninstalled from previous generation: " + bundlesToUninstall);
        this.bundlesFromNewGeneration = Map.of();
        this.obsoleteBundles = Map.of();
        this.readyForNewBundles = true;
        return bundlesToUninstall;
    }

    private Set<Bundle> revertToPreviousGeneration() {
        log.info("Reverting to previous generation with bundles: " + this.obsoleteBundles);
        log.info("Bundles from latest generation will be removed: " + this.bundlesFromNewGeneration);
        this.activeBundles.putAll(this.obsoleteBundles);
        this.bundlesFromNewGeneration.forEach(this.activeBundles::remove);
        LinkedHashSet<Bundle> ret = new LinkedHashSet<Bundle>(this.bundlesFromNewGeneration.values());
        this.osgi.allowDuplicateBundles(ret);
        this.bundlesFromNewGeneration = Map.of();
        this.obsoleteBundles = Map.of();
        this.readyForNewBundles = true;
        return ret;
    }

    private Map<FileReference, Bundle> removeObsoleteReferences(List<FileReference> newReferences) {
        LinkedHashMap<FileReference, Bundle> obsoleteReferences = new LinkedHashMap<FileReference, Bundle>(this.activeBundles);
        newReferences.forEach(obsoleteReferences::remove);
        obsoleteReferences.forEach(this.activeBundles::remove);
        return obsoleteReferences;
    }

    private Map<FileReference, Bundle> installBundles(List<FileReference> references) {
        HashSet<FileReference> bundlesToInstall = new HashSet<FileReference>(references);
        bundlesToInstall.removeAll(this.activeBundles.keySet());
        if (bundlesToInstall.isEmpty()) {
            return Map.of();
        }
        if (this.bundleInstaller.hasFileDistribution()) {
            return this.installWithFileDistribution(bundlesToInstall, this.bundleInstaller);
        }
        log.warning("Can't retrieve bundles since file distribution is disabled.");
        return Map.of();
    }

    private Map<FileReference, Bundle> installWithFileDistribution(Set<FileReference> bundlesToInstall, FileAcquirerBundleInstaller bundleInstaller) {
        LinkedHashMap<FileReference, Bundle> newBundles = new LinkedHashMap<FileReference, Bundle>();
        for (FileReference reference : bundlesToInstall) {
            try {
                log.info("Installing bundle with reference '" + reference.value() + "'");
                List<Bundle> bundles = bundleInstaller.installBundles(reference, this.osgi);
                if (bundles.size() > 1 && this.osgi.hasFelixFramework()) {
                    throw new RuntimeException("Bundle '" + bundles.get(0).getSymbolicName() + "' tried to pre-install bundles from disk.");
                }
                this.activeBundles.put(reference, bundles.get(0));
                newBundles.put(reference, bundles.get(0));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not install bundle with reference '" + reference + "'", e);
            }
        }
        return newBundles;
    }

    private String installedBundlesMessage() {
        StringBuilder sb = new StringBuilder("Installed bundles: {");
        for (Bundle b : this.osgi.getBundles()) {
            sb.append("[" + b.getBundleId() + "]" + b.getSymbolicName() + ":" + b.getVersion() + ", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("}");
        return sb.toString();
    }

    List<FileReference> getActiveFileReferences() {
        return new ArrayList<FileReference>(this.activeBundles.keySet());
    }
}

