/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter;

import com.yahoo.jdisc.AbstractResource;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.filter.DiscFilterRequest;
import com.yahoo.jdisc.http.filter.RequestFilter;
import com.yahoo.jdisc.http.filter.SecurityRequestFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SecurityRequestFilterChain
extends AbstractResource
implements RequestFilter {
    private final List<SecurityRequestFilter> filters = new ArrayList<SecurityRequestFilter>();

    private SecurityRequestFilterChain(Iterable<? extends SecurityRequestFilter> filters) {
        for (SecurityRequestFilter securityRequestFilter : filters) {
            this.filters.add(securityRequestFilter);
        }
    }

    @Override
    public void filter(HttpRequest request, ResponseHandler responseHandler) {
        DiscFilterRequest discFilterRequest = new DiscFilterRequest(request);
        this.filter(discFilterRequest, responseHandler);
    }

    public void filter(DiscFilterRequest request, ResponseHandler responseHandler) {
        ResponseHandlerGuard guard = new ResponseHandlerGuard(responseHandler);
        int len = this.filters.size();
        for (int i = 0; i < len && !guard.isDone(); ++i) {
            this.filters.get(i).filter(request, guard);
        }
    }

    public static RequestFilter newInstance(SecurityRequestFilter ... filters) {
        return SecurityRequestFilterChain.newInstance(Arrays.asList(filters));
    }

    public static RequestFilter newInstance(List<? extends SecurityRequestFilter> filters) {
        return new SecurityRequestFilterChain(filters);
    }

    public List<SecurityRequestFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    private static class ResponseHandlerGuard
    implements ResponseHandler {
        private final ResponseHandler responseHandler;
        private boolean done = false;

        public ResponseHandlerGuard(ResponseHandler handler) {
            this.responseHandler = handler;
        }

        public ContentChannel handleResponse(Response response) {
            this.done = true;
            return this.responseHandler.handleResponse(response);
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

