/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple.jdisc;

import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.application.MetricConsumer;
import com.yahoo.metrics.simple.Identifier;
import com.yahoo.metrics.simple.Measurement;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.metrics.simple.Point;
import com.yahoo.metrics.simple.Sample;
import com.yahoo.metrics.simple.UntypedMetric;
import java.util.Map;

public class SimpleMetricConsumer
implements MetricConsumer {
    private final MetricReceiver receiver;

    public SimpleMetricConsumer(MetricReceiver receiver) {
        this.receiver = receiver;
    }

    public void set(String key, Number val, Metric.Context ctx) {
        this.receiver.update(new Sample(new Measurement(val), new Identifier(key, this.getSimpleCoordinate(ctx)), UntypedMetric.AssumedType.GAUGE));
    }

    public void add(String key, Number val, Metric.Context ctx) {
        this.receiver.update(new Sample(new Measurement(val), new Identifier(key, this.getSimpleCoordinate(ctx)), UntypedMetric.AssumedType.COUNTER));
    }

    private Point getSimpleCoordinate(Metric.Context ctx) {
        if (ctx instanceof Point) {
            return (Point)ctx;
        }
        return null;
    }

    public Metric.Context createContext(Map<String, ?> properties) {
        if (properties == null || properties.isEmpty()) {
            return Point.emptyPoint();
        }
        return new Point(properties);
    }
}

