/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics;

public enum Unit {
    BYTE(BaseUnit.BYTE),
    CONNECTION(BaseUnit.CONNECTION),
    DOCUMENT(BaseUnit.DOCUMENT),
    DOCUMENT_PER_SECOND(BaseUnit.DOCUMENT, BaseUnit.SECOND),
    FRACTION(BaseUnit.FRACTION),
    HIT(BaseUnit.HIT),
    HIT_PER_QUERY(BaseUnit.HIT, BaseUnit.QUERY),
    ITEM(BaseUnit.ITEM),
    MILLISECOND(BaseUnit.MILLISECOND),
    OPERATION(BaseUnit.OPERATION),
    OPERATION_PER_SECOND(BaseUnit.OPERATION, BaseUnit.SECOND),
    QUERY(BaseUnit.QUERY),
    QUERY_PER_SECOND(BaseUnit.QUERY, BaseUnit.SECOND),
    REQUEST(BaseUnit.REQUEST),
    RESPONSE(BaseUnit.RESPONSE),
    RESPONSE_PER_SECOND(BaseUnit.RESPONSE, BaseUnit.SECOND),
    SCORE(BaseUnit.SCORE),
    SECOND(BaseUnit.SECOND),
    THREAD(BaseUnit.THREAD);

    private final BaseUnit unit;
    private final BaseUnit perUnit;

    private Unit(BaseUnit unit) {
        this(unit, null);
    }

    private Unit(BaseUnit unit, BaseUnit perUnit) {
        this.unit = unit;
        this.perUnit = perUnit;
    }

    public String fullName() {
        return this.perUnit == null ? this.unit.fullName() : this.unit.fullName() + "/" + this.perUnit.fullName();
    }

    public String shortName() {
        return this.perUnit == null ? this.unit.shortName : this.unit.shortName + "/" + this.perUnit.shortName;
    }

    private static enum BaseUnit {
        BYTE("byte"),
        CONNECTION("connection"),
        DOCUMENT("document"),
        FRACTION("fraction"),
        HIT("hit"),
        ITEM("item"),
        MILLISECOND("millisecond", "ms"),
        OPERATION("operation"),
        QUERY("query"),
        REQUEST("request"),
        RESPONSE("response"),
        SCORE("score"),
        SECOND("second", "s"),
        THREAD("thread");

        private final String fullName;
        private final String shortName;

        private BaseUnit(String fullName) {
            this(fullName, fullName);
        }

        private BaseUnit(String fullName, String shortName) {
            this.fullName = fullName;
            this.shortName = shortName;
        }

        public String fullName() {
            return this.fullName;
        }

        public String shortName() {
            return this.shortName;
        }
    }
}

