/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.jdisc.http.server.jetty.MetricDefinitions;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.ObjLongConsumer;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.component.Graceful;

class HttpResponseStatisticsCollector
extends HandlerWrapper
implements Graceful {
    static final String requestTypeAttribute = "requestType";
    private final Graceful.Shutdown shutdown;
    private final List<String> monitoringHandlerPaths;
    private final List<String> searchHandlerPaths;
    private final Set<String> ignoredUserAgents;
    private final AtomicLong inFlight = new AtomicLong();
    private final ConcurrentMap<StatusCodeMetric, LongAdder> statistics = new ConcurrentHashMap<StatusCodeMetric, LongAdder>();
    private final AsyncListener completionWatcher = new AsyncListener(){

        public void onTimeout(AsyncEvent event) {
        }

        public void onStartAsync(AsyncEvent event) {
            event.getAsyncContext().addListener((AsyncListener)this);
        }

        public void onError(AsyncEvent event) {
        }

        public void onComplete(AsyncEvent event) throws IOException {
            HttpChannelState state = ((AsyncContextEvent)event).getHttpChannelState();
            Request request = state.getBaseRequest();
            HttpResponseStatisticsCollector.this.observeEndOfRequest(request, null);
        }
    };

    HttpResponseStatisticsCollector(ServerConfig.Metric cfg) {
        this(cfg.monitoringHandlerPaths(), cfg.searchHandlerPaths(), cfg.ignoredUserAgents());
    }

    HttpResponseStatisticsCollector(List<String> monitoringHandlerPaths, List<String> searchHandlerPaths, Collection<String> ignoredUserAgents) {
        this.monitoringHandlerPaths = monitoringHandlerPaths;
        this.searchHandlerPaths = searchHandlerPaths;
        this.ignoredUserAgents = Set.copyOf(ignoredUserAgents);
        this.shutdown = new Graceful.Shutdown((Object)this){

            public boolean isShutdownDone() {
                return HttpResponseStatisticsCollector.this.inFlight.get() == 0L;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String path, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.inFlight.incrementAndGet();
        try {
            Handler handler = this.getHandler();
            if (handler != null && !this.shutdown.isShutdown() && this.isStarted()) {
                handler.handle(path, baseRequest, request, response);
            } else if (!baseRequest.isHandled()) {
                baseRequest.setHandled(true);
                response.sendError(503);
            }
        }
        finally {
            HttpChannelState state = baseRequest.getHttpChannelState();
            if (state.isSuspended()) {
                if (state.isInitial()) {
                    state.addListener(this.completionWatcher);
                }
            } else if (state.isInitial()) {
                this.observeEndOfRequest(baseRequest, response);
            }
        }
    }

    private boolean shouldLogMetricsFor(Request request) {
        String agent = request.getHeader(HttpHeader.USER_AGENT.toString());
        if (agent == null) {
            return true;
        }
        return !this.ignoredUserAgents.contains(agent);
    }

    private void observeEndOfRequest(Request request, HttpServletResponse flushableResponse) throws IOException {
        if (this.shouldLogMetricsFor(request)) {
            Collection<StatusCodeMetric> metrics = StatusCodeMetric.of(request, this.monitoringHandlerPaths, this.searchHandlerPaths);
            metrics.forEach(metric -> this.statistics.computeIfAbsent((StatusCodeMetric)metric, __ -> new LongAdder()).increment());
        }
        long live = this.inFlight.decrementAndGet();
        if (this.shutdown.isShutdown()) {
            if (flushableResponse != null) {
                flushableResponse.flushBuffer();
            }
            if (live == 0L) {
                this.shutdown.check();
            }
        }
    }

    List<StatisticsEntry> takeStatistics() {
        ArrayList<StatisticsEntry> ret = new ArrayList<StatisticsEntry>();
        this.consume((metric, value) -> ret.add(new StatisticsEntry((StatusCodeMetric)metric, value)));
        return ret;
    }

    void reportSnapshot(Metric metricAggregator) {
        this.consume((metric, value) -> {
            Metric.Context ctx = metricAggregator.createContext(metric.dimensions.asMap());
            metricAggregator.add(metric.name, (Number)value, ctx);
        });
    }

    private void consume(ObjLongConsumer<StatusCodeMetric> consumer) {
        this.statistics.forEach((metric, adder) -> {
            long value = adder.sumThenReset();
            if (value > 0L) {
                consumer.accept((StatusCodeMetric)metric, value);
            }
        });
    }

    protected void doStart() throws Exception {
        this.shutdown.cancel();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.shutdown.cancel();
        super.doStop();
    }

    public CompletableFuture<Void> shutdown() {
        return this.shutdown.shutdown();
    }

    public boolean isShutdown() {
        return this.shutdown.isShutdown();
    }

    static class StatusCodeMetric {
        final Dimensions dimensions;
        final String name;

        private StatusCodeMetric(Dimensions dimensions, String name) {
            this.dimensions = dimensions;
            this.name = name;
        }

        static Collection<StatusCodeMetric> of(Request req, Collection<String> monitoringHandlerPaths, Collection<String> searchHandlerPaths) {
            Dimensions dimensions = Dimensions.of(req, monitoringHandlerPaths, searchHandlerPaths);
            return StatusCodeMetric.metricNames(req).stream().map(name -> new StatusCodeMetric(dimensions, (String)name)).collect(Collectors.toSet());
        }

        private static Collection<String> metricNames(Request req) {
            int code = req.getResponse().getStatus();
            if (code < 200) {
                return Set.of(MetricDefinitions.RESPONSES_1XX);
            }
            if (code < 300) {
                return Set.of(MetricDefinitions.RESPONSES_2XX);
            }
            if (code < 400) {
                return Set.of(MetricDefinitions.RESPONSES_3XX);
            }
            if (code < 500) {
                return Set.of(MetricDefinitions.RESPONSES_4XX);
            }
            return Set.of(MetricDefinitions.RESPONSES_5XX);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatusCodeMetric that = (StatusCodeMetric)o;
            return Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.dimensions, this.name);
        }
    }

    static class Dimensions {
        final String protocol;
        final String scheme;
        final String method;
        final String requestType;
        final int statusCode;

        private Dimensions(String protocol, String scheme, String method, String requestType, int statusCode) {
            this.protocol = protocol;
            this.scheme = scheme;
            this.method = method;
            this.requestType = requestType;
            this.statusCode = statusCode;
        }

        static Dimensions of(Request req, Collection<String> monitoringHandlerPaths, Collection<String> searchHandlerPaths) {
            String requestType = Dimensions.requestType(req, monitoringHandlerPaths, searchHandlerPaths);
            return new Dimensions(Dimensions.protocol(req), Dimensions.scheme(req), Dimensions.method(req), requestType, Dimensions.statusCode(req));
        }

        Map<String, Object> asMap() {
            HashMap<String, Object> builder = new HashMap<String, Object>();
            builder.put("protocol", this.protocol);
            builder.put("scheme", this.scheme);
            builder.put("httpMethod", this.method);
            builder.put(HttpResponseStatisticsCollector.requestTypeAttribute, this.requestType);
            builder.put("statusCode", Long.valueOf(this.statusCode));
            return Map.copyOf(builder);
        }

        private static String protocol(Request req) {
            switch (req.getProtocol()) {
                case "HTTP/1": 
                case "HTTP/1.0": 
                case "HTTP/1.1": {
                    return "http1";
                }
                case "HTTP/2": 
                case "HTTP/2.0": {
                    return "http2";
                }
            }
            return "other";
        }

        private static String scheme(Request req) {
            switch (req.getScheme()) {
                case "http": 
                case "https": {
                    return req.getScheme();
                }
            }
            return "other";
        }

        private static String method(Request req) {
            switch (req.getMethod()) {
                case "GET": 
                case "PATCH": 
                case "POST": 
                case "PUT": 
                case "DELETE": 
                case "OPTIONS": 
                case "HEAD": {
                    return req.getMethod();
                }
            }
            return "other";
        }

        private static int statusCode(Request req) {
            return req.getResponse().getStatus();
        }

        private static String requestType(Request req, Collection<String> monitoringHandlerPaths, Collection<String> searchHandlerPaths) {
            Request.RequestType requestType = (Request.RequestType)req.getAttribute(HttpResponseStatisticsCollector.requestTypeAttribute);
            if (requestType != null) {
                return requestType.name().toLowerCase();
            }
            String path = req.getRequestURI();
            for (String monitoringHandlerPath : monitoringHandlerPaths) {
                if (!path.startsWith(monitoringHandlerPath)) continue;
                return "monitoring";
            }
            for (String searchHandlerPath : searchHandlerPaths) {
                if (!path.startsWith(searchHandlerPath)) continue;
                return "read";
            }
            if ("GET".equals(req.getMethod())) {
                return "read";
            }
            return "write";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Dimensions that = (Dimensions)o;
            return this.statusCode == that.statusCode && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.method, that.method) && Objects.equals(this.requestType, that.requestType);
        }

        public int hashCode() {
            return Objects.hash(this.protocol, this.scheme, this.method, this.requestType, this.statusCode);
        }
    }

    static class StatisticsEntry {
        final Dimensions dimensions;
        final String name;
        final long value;

        StatisticsEntry(StatusCodeMetric metric, long value) {
            this.dimensions = metric.dimensions;
            this.name = metric.name;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatisticsEntry that = (StatisticsEntry)o;
            return this.value == that.value && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.dimensions, this.name, this.value);
        }
    }
}

