/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.google.inject.Inject;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.SslProvider;
import com.yahoo.jdisc.http.server.jetty.ConnectionMetricAggregator;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import com.yahoo.jdisc.http.server.jetty.JettyConnectionLogger;
import com.yahoo.jdisc.http.server.jetty.SslHandshakeFailedListener;
import com.yahoo.jdisc.http.ssl.SslContextFactoryProvider;
import com.yahoo.jdisc.http.ssl.impl.DefaultConnectorSsl;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http2.server.AbstractHTTP2ServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DetectorConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ConnectorFactory {
    private static final Logger log = Logger.getLogger(ConnectorFactory.class.getName());
    private final ConnectorConfig connectorConfig;
    private final SslProvider sslProvider;

    @Inject
    public ConnectorFactory(ConnectorConfig connectorConfig, SslProvider sslProvider) {
        ConnectorFactory.runtimeConnectorConfigValidation(connectorConfig);
        this.connectorConfig = connectorConfig;
        this.sslProvider = sslProvider;
    }

    private static void runtimeConnectorConfigValidation(ConnectorConfig config) {
        ConnectorFactory.validateProxyProtocolConfiguration(config);
        ConnectorFactory.validateSecureRedirectConfig(config);
    }

    private static void validateProxyProtocolConfiguration(ConnectorConfig config) {
        ConnectorConfig.ProxyProtocol proxyProtocolConfig = config.proxyProtocol();
        if (proxyProtocolConfig.enabled()) {
            boolean tlsMixedModeEnabled;
            boolean bl = tlsMixedModeEnabled = TransportSecurityUtils.getInsecureMixedMode() != MixedMode.DISABLED;
            if (!ConnectorFactory.isSslEffectivelyEnabled(config) || tlsMixedModeEnabled) {
                throw new IllegalArgumentException("Proxy protocol can only be enabled if connector is effectively HTTPS only");
            }
        }
    }

    private static void validateSecureRedirectConfig(ConnectorConfig config) {
        if (config.secureRedirect().enabled() && ConnectorFactory.isSslEffectivelyEnabled(config)) {
            throw new IllegalArgumentException("Secure redirect can only be enabled on connectors without HTTPS");
        }
    }

    public ConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public ServerConnector createConnector(Metric metric, Server server, JettyConnectionLogger connectionLogger, ConnectionMetricAggregator connectionMetricAggregator) {
        JDiscServerConnector connector = new JDiscServerConnector(this.connectorConfig, metric, server, connectionLogger, connectionMetricAggregator, (ConnectionFactory[])this.createConnectionFactories(metric).toArray(ConnectionFactory[]::new));
        connector.setPort(this.connectorConfig.listenPort());
        connector.setName(this.connectorConfig.name());
        connector.setAcceptQueueSize(this.connectorConfig.acceptQueueSize());
        connector.setReuseAddress(this.connectorConfig.reuseAddress());
        connector.setIdleTimeout(ConnectorFactory.toMillis(this.connectorConfig.idleTimeout()));
        connector.addBean(HttpCompliance.RFC7230);
        return connector;
    }

    private List<ConnectionFactory> createConnectionFactories(Metric metric) {
        boolean vespaTlsEnabled = TransportSecurityUtils.isTransportSecurityEnabled() && this.connectorConfig.implicitTlsEnabled();
        MixedMode tlsMixedMode = TransportSecurityUtils.getInsecureMixedMode();
        if (this.connectorConfig.ssl().enabled() || vespaTlsEnabled && tlsMixedMode == MixedMode.DISABLED) {
            return this.connectionFactoriesForHttps(metric);
        }
        if (vespaTlsEnabled) {
            if (tlsMixedMode != MixedMode.TLS_CLIENT_MIXED_SERVER && tlsMixedMode != MixedMode.PLAINTEXT_CLIENT_MIXED_SERVER) {
                throw new IllegalArgumentException("Unknown mixed mode " + tlsMixedMode);
            }
            return this.connectionFactoriesForTlsMixedMode(metric);
        }
        return this.connectorConfig.http2Enabled() ? List.of(this.newHttp1ConnectionFactory(), this.newHttp2ClearTextConnectionFactory()) : List.of(this.newHttp1ConnectionFactory());
    }

    private List<ConnectionFactory> connectionFactoriesForHttps(Metric metric) {
        SslConnectionFactory sslFactory;
        ALPNServerConnectionFactory alpnFactory;
        ArrayList<Object> factories = new ArrayList<Object>();
        ConnectorConfig.ProxyProtocol proxyProtocolConfig = this.connectorConfig.proxyProtocol();
        HttpConnectionFactory http1Factory = this.newHttp1ConnectionFactory();
        if (this.connectorConfig.http2Enabled()) {
            alpnFactory = this.newAlpnConnectionFactory();
            sslFactory = this.newSslConnectionFactory(metric, (ConnectionFactory)alpnFactory);
        } else {
            alpnFactory = null;
            sslFactory = this.newSslConnectionFactory(metric, (ConnectionFactory)http1Factory);
        }
        if (proxyProtocolConfig.enabled()) {
            factories.add(this.newProxyProtocolConnectionFactory((ConnectionFactory)sslFactory, proxyProtocolConfig.mixedMode()));
        }
        factories.add(sslFactory);
        if (this.connectorConfig.http2Enabled()) {
            factories.add(alpnFactory);
        }
        factories.add(http1Factory);
        if (this.connectorConfig.http2Enabled()) {
            factories.add(this.newHttp2ConnectionFactory());
        }
        return List.copyOf(factories);
    }

    private List<ConnectionFactory> connectionFactoriesForTlsMixedMode(Metric metric) {
        log.warning(String.format("TLS mixed mode enabled for port %d - HTTP/2 and proxy-protocol are not supported", this.connectorConfig.listenPort()));
        HttpConnectionFactory httpFactory = this.newHttp1ConnectionFactory();
        SslConnectionFactory sslFactory = this.newSslConnectionFactory(metric, (ConnectionFactory)httpFactory);
        DetectorConnectionFactory detectorFactory = this.newDetectorConnectionFactory(new ConnectionFactory.Detecting[]{sslFactory});
        return List.of(detectorFactory, httpFactory, sslFactory);
    }

    private HttpConfiguration newHttpConfiguration() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendDateHeader(true);
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendXPoweredBy(false);
        httpConfig.setHeaderCacheSize(this.connectorConfig.headerCacheSize());
        httpConfig.setOutputBufferSize(this.connectorConfig.outputBufferSize());
        httpConfig.setRequestHeaderSize(this.connectorConfig.requestHeaderSize());
        httpConfig.setResponseHeaderSize(this.connectorConfig.responseHeaderSize());
        if (ConnectorFactory.isSslEffectivelyEnabled(this.connectorConfig)) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        }
        return httpConfig;
    }

    private HttpConnectionFactory newHttp1ConnectionFactory() {
        return new HttpConnectionFactory(this.newHttpConfiguration());
    }

    private HTTP2ServerConnectionFactory newHttp2ConnectionFactory() {
        HTTP2ServerConnectionFactory factory = new HTTP2ServerConnectionFactory(this.newHttpConfiguration());
        this.setHttp2Config((AbstractHTTP2ServerConnectionFactory)factory);
        return factory;
    }

    private HTTP2CServerConnectionFactory newHttp2ClearTextConnectionFactory() {
        HTTP2CServerConnectionFactory factory = new HTTP2CServerConnectionFactory(this.newHttpConfiguration());
        this.setHttp2Config((AbstractHTTP2ServerConnectionFactory)factory);
        return factory;
    }

    private void setHttp2Config(AbstractHTTP2ServerConnectionFactory factory) {
        factory.setStreamIdleTimeout(ConnectorFactory.toMillis(this.connectorConfig.http2().streamIdleTimeout()));
        factory.setMaxConcurrentStreams(this.connectorConfig.http2().maxConcurrentStreams());
        factory.setInitialSessionRecvWindow(0x1000000);
        factory.setInitialStreamRecvWindow(0x100000);
    }

    private SslConnectionFactory newSslConnectionFactory(Metric metric, ConnectionFactory wrappedFactory) {
        SslConnectionFactory connectionFactory = new SslConnectionFactory(this.createSslContextFactory(), wrappedFactory.getProtocol());
        connectionFactory.addBean((Object)new SslHandshakeFailedListener(metric, this.connectorConfig.name(), this.connectorConfig.listenPort()));
        return connectionFactory;
    }

    private SslContextFactory createSslContextFactory() {
        try {
            DefaultConnectorSsl ssl = new DefaultConnectorSsl();
            this.sslProvider.configureSsl(ssl, this.connectorConfig.name(), this.connectorConfig.listenPort());
            return ssl.createSslContextFactory();
        }
        catch (UnsupportedOperationException e) {
            if (this.sslProvider instanceof SslContextFactoryProvider) {
                return ((SslContextFactoryProvider)this.sslProvider).getInstance(this.connectorConfig.name(), this.connectorConfig.listenPort());
            }
            throw e;
        }
    }

    private ALPNServerConnectionFactory newAlpnConnectionFactory() {
        ALPNServerConnectionFactory factory = new ALPNServerConnectionFactory(new String[]{"h2", "http/1.1"});
        factory.setDefaultProtocol("http/1.1");
        return factory;
    }

    private DetectorConnectionFactory newDetectorConnectionFactory(ConnectionFactory.Detecting ... alternatives) {
        return new DetectorConnectionFactory(alternatives);
    }

    private ProxyConnectionFactory newProxyProtocolConnectionFactory(ConnectionFactory wrapped, boolean mixedMode) {
        return mixedMode ? new ProxyConnectionFactory(wrapped.getProtocol()) : new MandatoryProxyConnectionFactory(wrapped.getProtocol());
    }

    private static boolean isSslEffectivelyEnabled(ConnectorConfig config) {
        return config.ssl().enabled() || config.implicitTlsEnabled() && TransportSecurityUtils.isTransportSecurityEnabled();
    }

    private static long toMillis(double seconds) {
        return (long)(seconds * 1000.0);
    }

    private static class MandatoryProxyConnectionFactory
    extends ProxyConnectionFactory {
        MandatoryProxyConnectionFactory(String next) {
            super(next);
        }

        protected String findNextProtocol(Connector __) {
            return null;
        }
    }
}

