/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.container.logging.ConnectionLog;
import com.yahoo.container.logging.ConnectionLogConfig;
import com.yahoo.container.logging.ConnectionLogEntry;
import com.yahoo.container.logging.ConnectionLogHandler;
import com.yahoo.container.logging.JsonConnectionLogWriter;

public class FileConnectionLog
extends AbstractComponent
implements ConnectionLog {
    private final ConnectionLogHandler logHandler;

    @Inject
    public FileConnectionLog(ConnectionLogConfig config) {
        this.logHandler = new ConnectionLogHandler(config.logDirectoryName(), config.bufferSize(), config.cluster(), FileConnectionLog.queueSize(config), new JsonConnectionLogWriter(), config.useClusterIdInFileName());
    }

    private static int queueSize(ConnectionLogConfig config) {
        if (config.queueSize() != -1) {
            return config.queueSize();
        }
        return Math.max(4096, Runtime.getRuntime().availableProcessors() * 512);
    }

    @Override
    public void log(ConnectionLogEntry connectionLogEntry) {
        this.logHandler.log(connectionLogEntry);
    }

    public void deconstruct() {
        this.logHandler.shutdown();
    }
}

