/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.test;

import com.yahoo.component.chain.Chain;
import com.yahoo.processing.Processor;
import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.AsyncExecution;
import com.yahoo.processing.execution.Execution;
import com.yahoo.processing.execution.ExecutionWithResponse;
import com.yahoo.processing.execution.RunnableExecution;
import com.yahoo.processing.request.ErrorMessage;
import com.yahoo.processing.response.AbstractData;
import com.yahoo.processing.response.ArrayDataList;
import com.yahoo.processing.response.Data;
import com.yahoo.processing.response.DataList;
import com.yahoo.processing.response.FutureResponse;
import com.yahoo.processing.response.IncomingData;
import com.yahoo.processing.response.Ordered;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class ProcessorLibrary {
    private ProcessorLibrary() {
    }

    public static class LogValueAdder
    extends Processor {
        private final String key;
        private final String value;

        public LogValueAdder(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Response process(Request request, Execution execution) {
            execution.trace().logValue(this.key, this.value);
            return execution.process(request);
        }
    }

    public static final class StatusSetter
    extends Processor {
        private final int status;

        public StatusSetter(int status) {
            this.status = status;
        }

        @Override
        public Response process(Request request, Execution execution) {
            request.errors().add(new ErrorMessage(this.status, ""));
            return execution.process(request);
        }
    }

    public static class Trace
    extends Processor {
        private String traceMessage;
        private int traceLevel;

        public Trace(String traceMessage, int traceLevel) {
            this.traceMessage = traceMessage;
            this.traceLevel = traceLevel;
        }

        @Override
        public Response process(Request request, Execution execution) {
            execution.trace().trace(this.traceMessage, this.traceLevel);
            return execution.process(request);
        }
    }

    public static class StringDataListAdder
    extends Processor {
        private String[] strings;

        public StringDataListAdder(String ... strings) {
            this.strings = strings;
        }

        @Override
        public Response process(Request request, Execution execution) {
            Response response = execution.process(request);
            ArrayDataList<StringData> list = ArrayDataList.create(request);
            for (String string : this.strings) {
                list.add(new StringData(request, string));
            }
            response.data().add(list);
            return response;
        }
    }

    public static class ErrorAdder
    extends Processor {
        private ErrorMessage errorMessage;

        public ErrorAdder(ErrorMessage errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public Response process(Request request, Execution execution) {
            Response response = execution.process(request);
            response.data().request().errors().add(this.errorMessage);
            return response;
        }
    }

    public static class StringDataAdder
    extends Processor {
        private String string;

        public StringDataAdder(String string) {
            this.string = string;
        }

        @Override
        public Response process(Request request, Execution execution) {
            Response response = execution.process(request);
            response.data().add(new StringData(request, this.string));
            return response;
        }
    }

    public static class Echo
    extends Processor {
        private String s;

        public Echo(String s) {
            this.s = s;
        }

        @Override
        public Response process(Request request, Execution execution) {
            System.out.println(this.s);
            return execution.process(request);
        }
    }

    public static class StreamProcessingInitiator
    extends Processor {
        private final Chain<Processor> streamChain;

        public StreamProcessingInitiator(Chain<Processor> streamChain) {
            this.streamChain = streamChain;
        }

        @Override
        public Response process(Request request, Execution execution) {
            Response response = execution.process(request);
            response.data().addDataListener(new RunnableExecution(request, new ExecutionWithResponse(this.streamChain, response, execution)));
            return response;
        }
    }

    public static class AsyncDataProcessingInitiator
    extends Processor {
        private final Chain<Processor> asyncChain;

        public AsyncDataProcessingInitiator(Chain<Processor> asyncChain) {
            this.asyncChain = asyncChain;
        }

        @Override
        public Response process(Request request, Execution execution) {
            Response response = execution.process(request);
            response.data().completeFuture().whenComplete((__, ___) -> new RunnableExecution(request, new ExecutionWithResponse(this.asyncChain, response, execution)).run());
            return response;
        }
    }

    public static class BlockingSplitter
    extends Processor {
        private final int parallelism;

        public BlockingSplitter(int parallelism) {
            this.parallelism = parallelism;
        }

        @Override
        public Response process(Request request, Execution execution) {
            try {
                ArrayList<FutureResponse> futures = new ArrayList<FutureResponse>(this.parallelism - 1);
                for (int i = 1; i < this.parallelism; ++i) {
                    futures.add(new AsyncExecution(execution).process(request.clone()));
                }
                Response response = execution.process(request);
                for (Response additionalResponse : AsyncExecution.waitForAll(futures, 1000L)) {
                    additionalResponse.data().completeFuture().get();
                    for (Object item : additionalResponse.data().asList()) {
                        response.data().add((Data)item);
                    }
                    response.mergeWith(additionalResponse);
                }
                return response;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class RequestCounter
    extends Processor {
        public final CompletableFuture<IncomingData> incomingData = new CompletableFuture();

        @Override
        public Response process(Request request, Execution execution) {
            ArrayDataList dataList = ArrayDataList.createAsync(request);
            this.incomingData.complete(dataList.incoming());
            return new Response(dataList);
        }
    }

    public static class ListenableFutureDataSource
    extends Processor {
        private final boolean ordered;
        private final boolean streamed;
        public final CompletableFuture<IncomingData> incomingData = new CompletableFuture();

        public ListenableFutureDataSource() {
            this(true, true);
        }

        public ListenableFutureDataSource(boolean ordered, boolean streamed) {
            this.ordered = ordered;
            this.streamed = streamed;
        }

        @Override
        public Response process(Request request, Execution execution) {
            ArrayDataList dataList = !this.ordered ? ArrayDataList.createAsyncUnordered(request) : (!this.streamed ? ArrayDataList.createAsyncNonstreamed(request) : ArrayDataList.createAsync(request));
            this.incomingData.complete(dataList.incoming());
            return new Response(dataList);
        }
    }

    public static class FutureDataSource
    extends Processor {
        public final List<IncomingData> incomingData = new ArrayList<IncomingData>();

        @Override
        public Response process(Request request, Execution execution) {
            ArrayDataList dataList = ArrayDataList.createAsync(request);
            this.incomingData.add(dataList.incoming());
            return new Response(dataList);
        }
    }

    public static class DataCounter
    extends Processor {
        private String prefix = "";

        public DataCounter() {
        }

        public DataCounter(String name) {
            this.prefix = "[" + name + "] ";
        }

        @Override
        public Response process(Request request, Execution execution) {
            Response response = execution.process(request);
            int dataCount = this.countData(response.data());
            response.data().add(new StringData(request, this.prefix + "Data count: " + dataCount));
            return response;
        }

        private int countData(DataList<? extends Data> dataList) {
            int count = 0;
            for (Data data : dataList.asList()) {
                if (data instanceof DataList) {
                    count += this.countData((DataList)data);
                    continue;
                }
                ++count;
            }
            return count;
        }
    }

    public static class EagerReturnFederator
    extends Processor {
        private final List<Chain<? extends Processor>> chains;
        private final boolean ordered;

        @SafeVarargs
        public EagerReturnFederator(Chain<? extends Processor> ... chains) {
            this(true, chains);
        }

        @SafeVarargs
        public EagerReturnFederator(boolean ordered, Chain<? extends Processor> ... chains) {
            this.chains = Arrays.asList(chains);
            this.ordered = ordered;
        }

        @Override
        public Response process(Request request, Execution execution) {
            ArrayList<FutureResponse> futureResponses = new ArrayList<FutureResponse>(this.chains.size());
            for (Chain<? extends Processor> chain : this.chains) {
                futureResponses.add(new AsyncExecution(chain, execution).process(request.clone()));
            }
            AsyncExecution.waitForAll(futureResponses, 1000L);
            Response response = this.ordered ? new Response(request) : new Response(new UnorderedArrayDataList(request));
            for (FutureResponse futureResponse : futureResponses) {
                Response federatedResponse = futureResponse.get();
                response.data().add(federatedResponse.data());
                response.mergeWith(federatedResponse);
            }
            return response;
        }
    }

    public static class Federator
    extends Processor {
        private final List<Chain<? extends Processor>> chains;
        private final boolean ordered;

        @SafeVarargs
        public Federator(Chain<? extends Processor> ... chains) {
            this(true, chains);
        }

        @SafeVarargs
        public Federator(boolean ordered, Chain<? extends Processor> ... chains) {
            this.chains = Arrays.asList(chains);
            this.ordered = ordered;
        }

        @Override
        public Response process(Request request, Execution execution) {
            Response response = this.ordered ? new Response(request) : new Response(new UnorderedArrayDataList(request));
            ArrayList<FutureResponse> futureResponses = new ArrayList<FutureResponse>(this.chains.size());
            for (Chain<? extends Processor> chain : this.chains) {
                futureResponses.add(new AsyncExecution(chain, execution).process(request.clone()));
            }
            AsyncExecution.waitForAll(futureResponses, 1000L);
            for (FutureResponse futureResponse : futureResponses) {
                Response federatedResponse = futureResponse.get();
                response.data().add(federatedResponse.data());
                response.mergeWith(federatedResponse);
            }
            return response;
        }
    }

    public static class DataSource
    extends Processor {
        @Override
        public Response process(Request request, Execution execution) {
            Response response = execution.process(request);
            response.data().add(new StringData(request, "first." + request.properties().get("appendage")));
            response.data().add(new StringData(request, "second." + request.properties().get("appendage")));
            response.data().add(new StringData(request, "third." + request.properties().get("appendage")));
            return response;
        }
    }

    public static class Get6DataItems
    extends Processor {
        @Override
        public Response process(Request request, Execution execution) {
            Response response = execution.process(request);
            while (response.data().asList().size() < 6) {
                request.properties().set("appendage", (Object)(request.properties().getInteger("appendage") + 1));
                Response additional = execution.process(request);
                response.mergeWith(additional);
                response.data().asList().addAll(additional.data().asList());
            }
            return response;
        }
    }

    public static class CombineData
    extends Processor {
        @Override
        public Response process(Request request, Execution execution) {
            request.properties().set("appendage", (Object)(request.properties().getInteger("appendage") + 1));
            Response response = execution.process(request);
            StringData first = (StringData)response.data().get(0);
            StringData third = (StringData)response.data().get(2);
            first.setString(first.toString() + ", " + third.toString());
            response.data().asList().remove(2);
            return response;
        }
    }

    public static class UnorderedArrayDataList
    extends ArrayDataList
    implements Ordered {
        public UnorderedArrayDataList(Request request) {
            super(request);
        }

        @Override
        public boolean isOrdered() {
            return false;
        }
    }

    public static class MapData
    extends AbstractData {
        private Map map = new LinkedHashMap();

        public MapData(Request request) {
            super(request);
        }

        public Map map() {
            return this.map;
        }

        public String toString() {
            return "map data: " + this.map;
        }
    }

    public static class StringData
    extends AbstractData {
        private String string;

        public StringData(Request request, String string) {
            super(request);
            this.string = string;
        }

        public void setString(String string) {
            this.string = string;
        }

        public String toString() {
            return this.string;
        }
    }
}

