/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.http.server.jetty.CompletionHandlerUtils;
import com.yahoo.jdisc.http.server.jetty.Janitor;
import com.yahoo.jdisc.http.server.jetty.RequestMetricReporter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

class ServletOutputStreamWriter {
    private static final Logger log = Logger.getLogger(ServletOutputStreamWriter.class.getName());
    private static final ByteBuffer CLOSE_STREAM_BUFFER = ByteBuffer.allocate(0);
    private final Object monitor = new Object();
    private State state = State.NOT_STARTED;
    private final ServletOutputStream outputStream;
    private final Janitor janitor;
    private final Deque<ResponseContentPart> responseContentQueue = new ArrayDeque<ResponseContentPart>();
    private final RequestMetricReporter metricReporter;
    private final CompletableFuture<Void> finishedFuture = new CompletableFuture();
    private final WriteListener writeListener = new WriteListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWritePossible() {
            Object object = ServletOutputStreamWriter.this.monitor;
            synchronized (object) {
                if (ServletOutputStreamWriter.this.state == State.FINISHED_OR_ERROR) {
                    return;
                }
                ServletOutputStreamWriter.assertStateIs(ServletOutputStreamWriter.this.state, State.WAITING_FOR_WRITE_POSSIBLE_CALLBACK);
                ServletOutputStreamWriter.this.state = State.WRITING_BUFFERS;
            }
            ServletOutputStreamWriter.this.writeBuffersInQueueToOutputStream();
        }

        public void onError(Throwable t) {
            ServletOutputStreamWriter.this.setFinished(t);
        }
    };

    ServletOutputStreamWriter(ServletOutputStream outputStream, Janitor janitor, RequestMetricReporter metricReporter) {
        this.outputStream = outputStream;
        this.janitor = janitor;
        this.metricReporter = metricReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBuffer(ByteBuffer buf, CompletionHandler handler) {
        boolean thisThreadShouldWrite = false;
        Throwable registrationFailure = null;
        Object object = this.monitor;
        synchronized (object) {
            if (this.state == State.FINISHED_OR_ERROR) {
                this.janitor.scheduleTask(() -> handler.failed((Throwable)new IllegalStateException("ContentChannel already closed.")));
                return;
            }
            this.responseContentQueue.addLast(new ResponseContentPart(buf, handler));
            switch (this.state) {
                case NOT_STARTED: {
                    try {
                        this.outputStream.setWriteListener(this.writeListener);
                        this.state = State.WAITING_FOR_WRITE_POSSIBLE_CALLBACK;
                    }
                    catch (Throwable t) {
                        registrationFailure = t;
                    }
                    break;
                }
                case WAITING_FOR_WRITE_POSSIBLE_CALLBACK: 
                case WRITING_BUFFERS: {
                    break;
                }
                case WAITING_FOR_BUFFER: {
                    thisThreadShouldWrite = true;
                    this.state = State.WRITING_BUFFERS;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid state " + this.state);
                }
            }
        }
        if (registrationFailure != null) {
            this.setFinished(registrationFailure);
        }
        if (thisThreadShouldWrite) {
            this.writeBuffersInQueueToOutputStream();
        }
    }

    void fail(Throwable t) {
        this.setFinished(t);
    }

    void close(CompletionHandler handler) {
        this.writeBuffer(CLOSE_STREAM_BUFFER, handler);
    }

    void close() {
        this.close(CompletionHandlerUtils.NOOP_COMPLETION_HANDLER);
    }

    CompletableFuture<Void> finishedFuture() {
        return this.finishedFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBuffersInQueueToOutputStream() {
        boolean lastOperationWasFlush = false;
        while (true) {
            ResponseContentPart contentPart;
            Object object = this.monitor;
            synchronized (object) {
                if (this.state == State.FINISHED_OR_ERROR) {
                    return;
                }
                ServletOutputStreamWriter.assertStateIs(this.state, State.WRITING_BUFFERS);
                if (!this.outputStream.isReady()) {
                    this.state = State.WAITING_FOR_WRITE_POSSIBLE_CALLBACK;
                    return;
                }
                contentPart = this.responseContentQueue.pollFirst();
                if (contentPart == null && lastOperationWasFlush) {
                    this.state = State.WAITING_FOR_BUFFER;
                    return;
                }
            }
            try {
                boolean isFlush;
                boolean bl = isFlush = contentPart == null;
                if (isFlush) {
                    this.outputStream.flush();
                    lastOperationWasFlush = true;
                    continue;
                }
                lastOperationWasFlush = false;
                if (contentPart.buf == CLOSE_STREAM_BUFFER) {
                    ServletOutputStreamWriter.callCompletionHandlerWhenDone(contentPart.handler, () -> this.outputStream.close());
                    this.setFinished(null);
                    return;
                }
                this.writeBufferToOutputStream(contentPart);
            }
            catch (Throwable t) {
                this.setFinished(t);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFinished(Throwable t) {
        Object object = this.monitor;
        synchronized (object) {
            this.state = State.FINISHED_OR_ERROR;
            if (!this.responseContentQueue.isEmpty()) {
                this.failAllParts_holdingLock(t != null ? t : new IllegalStateException("ContentChannel closed."));
            }
        }
        assert (!Thread.holdsLock(this.monitor));
        if (t != null) {
            this.finishedFuture.completeExceptionally(t);
        } else {
            this.finishedFuture.complete(null);
        }
    }

    private void failAllParts_holdingLock(Throwable e) {
        assert (Thread.holdsLock(this.monitor));
        ArrayList<ResponseContentPart> failedParts = new ArrayList<ResponseContentPart>(this.responseContentQueue);
        this.responseContentQueue.clear();
        RuntimeException failReason = new RuntimeException("Failing due to earlier ServletOutputStream write failure", e);
        Consumer<ResponseContentPart> failCompletionHandler = responseContentPart -> ServletOutputStreamWriter.runCompletionHandler_logOnExceptions(() -> responseContentPart.handler.failed((Throwable)failReason));
        this.janitor.scheduleTask(() -> failedParts.forEach(failCompletionHandler));
    }

    private void writeBufferToOutputStream(ResponseContentPart contentPart) throws Throwable {
        ServletOutputStreamWriter.callCompletionHandlerWhenDone(contentPart.handler, () -> {
            ByteBuffer buffer = contentPart.buf;
            int bytesToSend = buffer.remaining();
            try {
                if (buffer.hasArray()) {
                    this.outputStream.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                } else {
                    byte[] array = new byte[buffer.remaining()];
                    buffer.get(array);
                    this.outputStream.write(array);
                }
                this.metricReporter.successfulWrite(bytesToSend);
            }
            catch (Throwable throwable) {
                this.metricReporter.failedWrite();
                throw throwable;
            }
        });
    }

    private static void callCompletionHandlerWhenDone(CompletionHandler handler, IORunnable runnable) throws Exception {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            ServletOutputStreamWriter.runCompletionHandler_logOnExceptions(() -> handler.failed(e));
            throw e;
        }
        handler.completed();
    }

    private static void runCompletionHandler_logOnExceptions(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Unexpected exception from CompletionHandler.", e);
        }
    }

    private static void assertStateIs(State currentState, State expectedState) {
        if (currentState != expectedState) {
            AssertionError error = new AssertionError((Object)("Expected state " + expectedState + ", got state " + currentState));
            log.log(Level.WARNING, "Assertion failed.", (Throwable)((Object)error));
            throw error;
        }
    }

    private static enum State {
        NOT_STARTED,
        WAITING_FOR_WRITE_POSSIBLE_CALLBACK,
        WAITING_FOR_BUFFER,
        WRITING_BUFFERS,
        FINISHED_OR_ERROR;

    }

    private static class ResponseContentPart {
        public final ByteBuffer buf;
        public final CompletionHandler handler;

        public ResponseContentPart(ByteBuffer buf, CompletionHandler handler) {
            this.buf = buf;
            this.handler = handler;
        }
    }

    @FunctionalInterface
    private static interface IORunnable {
        public void run() throws IOException;
    }
}

