/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.container.logging.AccessLogEntry;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.handler.OverloadException;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.server.jetty.ExceptionWrapper;
import com.yahoo.jdisc.http.server.jetty.HttpRequestDispatch;
import com.yahoo.jdisc.http.server.jetty.JDiscContext;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

@WebServlet(asyncSupported=true, description="Bridge between Servlet and JDisc APIs")
class JDiscHttpServlet
extends HttpServlet {
    public static final String ATTRIBUTE_NAME_ACCESS_LOG_ENTRY = JDiscHttpServlet.class.getName() + "_access-log-entry";
    private static final Logger log = Logger.getLogger(JDiscHttpServlet.class.getName());
    private final JDiscContext context;
    private static final Set<String> servletSupportedMethods = Stream.of(HttpRequest.Method.OPTIONS, HttpRequest.Method.GET, HttpRequest.Method.HEAD, HttpRequest.Method.POST, HttpRequest.Method.PUT, HttpRequest.Method.DELETE, HttpRequest.Method.TRACE).map(Enum::name).collect(Collectors.toSet());

    public JDiscHttpServlet(JDiscContext context) {
        this.context = context;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.dispatchHttpRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.dispatchHttpRequest(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.dispatchHttpRequest(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.dispatchHttpRequest(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.dispatchHttpRequest(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.dispatchHttpRequest(request, response);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.dispatchHttpRequest(request, response);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute(JDiscServerConnector.REQUEST_ATTRIBUTE, (Object)RequestUtils.getConnector((Request)request));
        Metric.Context metricContext = JDiscHttpServlet.getMetricContext(request);
        this.context.metric.add("serverNumRequests", (Number)1, metricContext);
        this.context.metric.add("jdisc.http.requests", (Number)1, metricContext);
        String method = request.getMethod().toUpperCase();
        if (servletSupportedMethods.contains(method)) {
            super.service(request, response);
        } else if (method.equals(HttpRequest.Method.PATCH.name())) {
            this.dispatchHttpRequest(request, response);
        } else {
            response.sendError(405);
        }
    }

    private void dispatchHttpRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AccessLogEntry accessLogEntry = new AccessLogEntry();
        request.setAttribute(ATTRIBUTE_NAME_ACCESS_LOG_ENTRY, (Object)accessLogEntry);
        try {
            switch (request.getDispatcherType()) {
                case REQUEST: {
                    new HttpRequestDispatch(this.context, accessLogEntry, JDiscHttpServlet.getMetricContext(request), request, response).dispatchRequest();
                    break;
                }
                default: {
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Unexpected " + request.getDispatcherType() + "; " + JDiscHttpServlet.formatAttributes(request));
                    }
                    break;
                }
            }
        }
        catch (OverloadException overloadException) {
        }
        catch (RuntimeException e) {
            throw new ExceptionWrapper(e);
        }
    }

    private static Metric.Context getMetricContext(HttpServletRequest request) {
        return JDiscServerConnector.fromRequest((ServletRequest)request).createRequestMetricContext(request, Map.of());
    }

    private static String formatAttributes(HttpServletRequest request) {
        StringBuilder out = new StringBuilder();
        out.append("attributes = {");
        Enumeration names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            out.append(" '").append(name).append("' = '").append(request.getAttribute(name)).append("'");
            if (!names.hasMoreElements()) continue;
            out.append(",");
        }
        out.append(" }");
        return out.toString();
    }
}

