/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import com.yahoo.security.SslContextBuilder;
import com.yahoo.security.tls.TransportSecurityOptions;
import com.yahoo.security.tls.TransportSecurityUtils;
import com.yahoo.security.tls.TrustAllX509TrustManager;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.eclipse.jetty.server.DetectorConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.ssl.SslContextFactory;

class HealthCheckProxyHandler
extends HandlerWrapper {
    private static final Logger log = Logger.getLogger(HealthCheckProxyHandler.class.getName());
    private static final String HEALTH_CHECK_PATH = "/status.html";
    private final Executor executor = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("health-check-proxy-client-"));
    private final Map<Integer, ProxyTarget> portToProxyTargetMapping;

    HealthCheckProxyHandler(List<JDiscServerConnector> connectors) {
        this.portToProxyTargetMapping = HealthCheckProxyHandler.createPortToProxyTargetMapping(connectors);
    }

    private static Map<Integer, ProxyTarget> createPortToProxyTargetMapping(List<JDiscServerConnector> connectors) {
        HashMap<Integer, ProxyTarget> mapping = new HashMap<Integer, ProxyTarget>();
        for (JDiscServerConnector connector : connectors) {
            ConnectorConfig.HealthCheckProxy proxyConfig = connector.connectorConfig().healthCheckProxy();
            if (!proxyConfig.enable()) continue;
            Duration targetTimeout = Duration.ofMillis((int)(proxyConfig.clientTimeout() * 1000.0));
            mapping.put(connector.listenPort(), HealthCheckProxyHandler.createProxyTarget(proxyConfig.port(), targetTimeout, connectors));
            log.info(String.format("Port %1$d is configured as a health check proxy for port %2$d. HTTP requests to '%3$s' on %1$d are proxied as HTTPS to %2$d.", connector.listenPort(), proxyConfig.port(), HEALTH_CHECK_PATH));
        }
        return mapping;
    }

    private static ProxyTarget createProxyTarget(int targetPort, Duration targetTimeout, List<JDiscServerConnector> connectors) {
        JDiscServerConnector targetConnector = connectors.stream().filter(connector -> connector.listenPort() == targetPort).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find any connector with listen port " + targetPort));
        SslContextFactory.Server sslContextFactory = Optional.ofNullable((SslConnectionFactory)targetConnector.getConnectionFactory(SslConnectionFactory.class)).or(() -> Optional.ofNullable((DetectorConnectionFactory)targetConnector.getConnectionFactory(DetectorConnectionFactory.class)).map(detectorConnFactory -> (SslConnectionFactory)detectorConnFactory.getBean(SslConnectionFactory.class))).map(connFactory -> (SslContextFactory.Server)connFactory.getSslContextFactory()).orElseThrow(() -> new IllegalArgumentException("Health check proxy can only target https port"));
        return new ProxyTarget(targetPort, targetTimeout, sslContextFactory);
    }

    public void handle(String target, Request request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
        int localPort = RequestUtils.getConnectorLocalPort(request);
        ProxyTarget proxyTarget = this.portToProxyTargetMapping.get(localPort);
        if (proxyTarget != null) {
            AsyncContext asyncContext = servletRequest.startAsync();
            ServletOutputStream out = servletResponse.getOutputStream();
            if (servletRequest.getRequestURI().equals(HEALTH_CHECK_PATH)) {
                this.executor.execute(new ProxyRequestTask(asyncContext, proxyTarget, servletResponse, out));
            } else {
                servletResponse.setStatus(404);
                asyncContext.complete();
            }
            request.setHandled(true);
        } else {
            this._handler.handle(target, request, servletRequest, servletResponse);
        }
    }

    protected void doStop() throws Exception {
        for (ProxyTarget target : this.portToProxyTargetMapping.values()) {
            target.close();
        }
        super.doStop();
    }

    private static class ProxyTarget
    implements AutoCloseable {
        final int port;
        final Duration timeout;
        final SslContextFactory.Server sslContextFactory;
        volatile CloseableHttpClient client;
        volatile StatusResponse lastResponse;

        ProxyTarget(int port, Duration timeout, SslContextFactory.Server sslContextFactory) {
            this.port = port;
            this.timeout = timeout;
            this.sslContextFactory = sslContextFactory;
        }

        StatusResponse requestStatusHtml() {
            StatusResponse response = this.lastResponse;
            if (response != null && !response.isExpired()) {
                return response;
            }
            this.lastResponse = this.getStatusResponse();
            return this.lastResponse;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private StatusResponse getStatusResponse() {
            try (CloseableHttpResponse clientResponse = this.client().execute((HttpUriRequest)new HttpGet("https://localhost:" + this.port + HealthCheckProxyHandler.HEALTH_CHECK_PATH));){
                int statusCode = clientResponse.getStatusLine().getStatusCode();
                HttpEntity entity = clientResponse.getEntity();
                if (entity != null) {
                    Header contentTypeHeader = entity.getContentType();
                    String contentType = contentTypeHeader != null ? contentTypeHeader.getValue() : null;
                    byte[] content = EntityUtils.toByteArray((HttpEntity)entity);
                    StatusResponse statusResponse2 = new StatusResponse(statusCode, contentType, content);
                    return statusResponse2;
                }
                StatusResponse statusResponse = new StatusResponse(statusCode, null, null);
                return statusResponse;
            }
            catch (Exception e) {
                log.log(Level.FINE, e, () -> "Proxy request failed" + e.getMessage());
                return new StatusResponse(500, "text/plain", e.getMessage().getBytes());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CloseableHttpClient client() {
            if (this.client == null) {
                ProxyTarget proxyTarget = this;
                synchronized (proxyTarget) {
                    if (this.client == null) {
                        int timeoutMillis = (int)this.timeout.toMillis();
                        this.client = HttpClientBuilder.create().disableAutomaticRetries().setMaxConnPerRoute(4).setSSLContext(this.getSslContext(this.sslContextFactory)).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setUserTokenHandler(context -> null).setUserAgent("health-check-proxy-client").setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(timeoutMillis).setConnectionRequestTimeout(timeoutMillis).setSocketTimeout(timeoutMillis).build()).build();
                    }
                }
            }
            return this.client;
        }

        private SSLContext getSslContext(SslContextFactory.Server sslContextFactory) {
            if (sslContextFactory.getNeedClientAuth()) {
                log.info(String.format("Port %d requires client certificate - client will provide its node certificate", this.port));
                TransportSecurityOptions options = (TransportSecurityOptions)TransportSecurityUtils.getOptions().orElseThrow(() -> new IllegalStateException("Vespa TLS configuration is required when using health check proxy to a port with client auth 'need'"));
                return new SslContextBuilder().withKeyStore((Path)options.getPrivateKeyFile().get(), (Path)options.getCertificatesFile().get()).withTrustManager((X509ExtendedTrustManager)new TrustAllX509TrustManager()).build();
            }
            log.info(String.format("Port %d does not require a client certificate - client will not provide a certificate", this.port));
            return new SslContextBuilder().withTrustManager((X509ExtendedTrustManager)new TrustAllX509TrustManager()).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            ProxyTarget proxyTarget = this;
            synchronized (proxyTarget) {
                if (this.client != null) {
                    this.client.close();
                    this.client = null;
                }
            }
        }
    }

    private static class ProxyRequestTask
    implements Runnable {
        final AsyncContext asyncContext;
        final ProxyTarget target;
        final HttpServletResponse servletResponse;
        final ServletOutputStream output;

        ProxyRequestTask(AsyncContext asyncContext, ProxyTarget target, HttpServletResponse servletResponse, ServletOutputStream output) {
            this.asyncContext = asyncContext;
            this.target = target;
            this.servletResponse = servletResponse;
            this.output = output;
        }

        @Override
        public void run() {
            final StatusResponse statusResponse = this.target.requestStatusHtml();
            this.servletResponse.setStatus(statusResponse.statusCode);
            if (statusResponse.contentType != null) {
                this.servletResponse.setHeader("Content-Type", statusResponse.contentType);
            }
            this.servletResponse.setHeader("Vespa-Health-Check-Proxy-Target", Integer.toString(this.target.port));
            this.output.setWriteListener(new WriteListener(){

                public void onWritePossible() throws IOException {
                    if (output.isReady()) {
                        if (statusResponse.content != null) {
                            output.write(statusResponse.content);
                        }
                        asyncContext.complete();
                    }
                }

                public void onError(Throwable t) {
                    log.log(Level.FINE, t, () -> "Failed to write status response: " + t.getMessage());
                    asyncContext.complete();
                }
            });
        }
    }

    private static class StatusResponse {
        final long createdAt = System.nanoTime();
        final int statusCode;
        final String contentType;
        final byte[] content;

        StatusResponse(int statusCode, String contentType, byte[] content) {
            this.statusCode = statusCode;
            this.contentType = contentType;
            this.content = content;
        }

        boolean isExpired() {
            return System.nanoTime() - this.createdAt > Duration.ofSeconds(1L).toNanos();
        }
    }
}

