/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import ai.vespa.validation.StringWrapper;
import ai.vespa.validation.Validation;
import com.yahoo.net.DomainName;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.StringJoiner;
import java.util.function.Function;

public class HttpURL<T> {
    private final Scheme scheme;
    private final DomainName domain;
    private final int port;
    private final Path<T> path;
    private final Query<T> query;

    private HttpURL(Scheme scheme, DomainName domain, int port, Path<T> path, Query<T> query) {
        this.scheme = Objects.requireNonNull(scheme);
        this.domain = Objects.requireNonNull(domain);
        this.port = (Integer)Validation.requireInRange((Comparable)Integer.valueOf(port), (String)"port number", (Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(65535));
        this.path = Objects.requireNonNull(path);
        this.query = Objects.requireNonNull(query);
    }

    public static <T> HttpURL<T> create(Scheme scheme, DomainName domain, int port, Path<T> path, Query<T> query) {
        return new HttpURL<T>(scheme, domain, port, path, query);
    }

    public static HttpURL<String> create(Scheme scheme, DomainName domain, int port, Path<String> path) {
        return HttpURL.create(scheme, domain, port, path, Query.empty());
    }

    public static <T extends StringWrapper<T>> HttpURL<T> create(Scheme scheme, DomainName domain, int port, Path<T> path, Function<String, T> validator) {
        return HttpURL.create(scheme, domain, port, path, Query.empty(validator));
    }

    public static <T extends StringWrapper<T>> HttpURL<T> create(Scheme scheme, DomainName domain, int port, Function<String, T> validator) {
        return HttpURL.create(scheme, domain, port, Path.empty(validator), validator);
    }

    public static HttpURL<String> create(Scheme scheme, DomainName domain, int port) {
        return HttpURL.create(scheme, domain, port, Path.empty());
    }

    public static <T extends StringWrapper<T>> HttpURL<T> create(Scheme scheme, DomainName domain, Function<String, T> validator) {
        return HttpURL.create(scheme, domain, -1, validator);
    }

    public static HttpURL<String> create(Scheme scheme, DomainName domain) {
        return HttpURL.create(scheme, domain, -1);
    }

    public static HttpURL<String> from(URI uri) {
        return HttpURL.from(uri, Function.identity(), Function.identity());
    }

    public static <T extends StringWrapper<T>> HttpURL<T> from(URI uri, Function<String, T> validator) {
        return HttpURL.from(uri, validator, StringWrapper::value);
    }

    private static <T> HttpURL<T> from(URI uri, Function<String, T> validator, Function<T, String> inverse) {
        if (!uri.normalize().equals(uri)) {
            throw new IllegalArgumentException("uri should be normalized, but got: " + uri);
        }
        return HttpURL.create(Scheme.of(uri.getScheme()), DomainName.of((String)Objects.requireNonNull(uri.getHost(), "URI must specify a host")), uri.getPort(), Path.parse(uri.getRawPath(), validator, inverse), Query.parse(uri.getRawQuery(), validator, inverse));
    }

    public HttpURL<T> withScheme(Scheme scheme) {
        return HttpURL.create(scheme, this.domain, this.port, this.path, this.query);
    }

    public HttpURL<T> withDomain(DomainName domain) {
        return HttpURL.create(this.scheme, domain, this.port, this.path, this.query);
    }

    public HttpURL<T> withPort(int port) {
        return HttpURL.create(this.scheme, this.domain, port, this.path, this.query);
    }

    public HttpURL<T> withoutPort() {
        return HttpURL.create(this.scheme, this.domain, -1, this.path, this.query);
    }

    public HttpURL<T> withPath(Path<T> path) {
        return HttpURL.create(this.scheme, this.domain, this.port, path, this.query);
    }

    public HttpURL<T> withQuery(Query<T> query) {
        return HttpURL.create(this.scheme, this.domain, this.port, this.path, query);
    }

    public Scheme scheme() {
        return this.scheme;
    }

    public DomainName domain() {
        return this.domain;
    }

    public OptionalInt port() {
        return this.port == -1 ? OptionalInt.empty() : OptionalInt.of(this.port);
    }

    public Path<T> path() {
        return this.path;
    }

    public Query<T> query() {
        return this.query;
    }

    public URI asURI() {
        try {
            return new URI(this.scheme.name() + "://" + this.domain.value() + (String)(this.port == -1 ? "" : ":" + this.port) + this.path.raw() + this.query.raw());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("invalid URI, this should not happen", e);
        }
    }

    public static enum Scheme {
        http,
        https;


        public static Scheme of(String scheme) {
            if (scheme.equalsIgnoreCase(http.name())) {
                return http;
            }
            if (scheme.equalsIgnoreCase(https.name())) {
                return https;
            }
            throw new IllegalArgumentException("scheme must be HTTP or HTTPS");
        }
    }

    public static class Path<T> {
        private final List<T> segments;
        private final boolean trailingSlash;
        private final Function<String, T> validator;
        private final Function<T, String> inverse;

        private Path(List<T> segments, boolean trailingSlash, Function<String, T> validator, Function<T, String> inverse) {
            this.segments = Objects.requireNonNull(segments);
            this.trailingSlash = trailingSlash;
            this.validator = Objects.requireNonNull(validator);
            this.inverse = Objects.requireNonNull(inverse);
        }

        public static Path<String> empty() {
            return new Path<String>(List.of(), true, Function.identity(), Function.identity());
        }

        public static <T extends StringWrapper<T>> Path<T> empty(Function<String, T> validator) {
            return new Path<StringWrapper>(List.of(), true, validator, StringWrapper::value);
        }

        public static Path<String> from(List<String> segments) {
            return Path.empty().append(segments);
        }

        public static <T extends StringWrapper<T>> Path<T> from(List<String> segments, Function<String, T> validator) {
            return Path.empty(validator).append(segments, Function.identity(), true);
        }

        public static <T extends StringWrapper<T>> Path<T> parse(String raw, Function<String, T> validator) {
            return Path.parse(raw, validator, StringWrapper::value);
        }

        public static Path<String> parse(String raw) {
            return Path.parse(raw, Function.identity(), Function.identity());
        }

        private static <T> Path<T> parse(String raw, Function<String, T> validator, Function<T, String> inverse) {
            boolean trailingSlash = raw.endsWith("/");
            if (raw.startsWith("/")) {
                raw = raw.substring(1);
            }
            if (raw.isEmpty()) {
                return new Path(List.of(), trailingSlash, validator, inverse);
            }
            ArrayList<T> segments = new ArrayList<T>();
            for (String segment : raw.split("/")) {
                segments.add(validator.apply(Path.requireNonNormalizable(URLDecoder.decode(segment, StandardCharsets.UTF_8))));
            }
            if (segments.size() == 0) {
                Path.requireNonNormalizable("");
            }
            return new Path(segments, trailingSlash, validator, inverse);
        }

        private static String requireNonNormalizable(String segment) {
            return (String)Validation.require((!segment.isEmpty() && !segment.equals(".") && !segment.equals("..") ? 1 : 0) != 0, (Object)segment, (String)"path segments cannot be \"\", \".\", or \"..\"");
        }

        public Path<T> skip(int count) {
            return new Path<T>(this.segments.subList(count, this.segments.size()), this.trailingSlash, this.validator, this.inverse);
        }

        public Path<T> cut(int count) {
            return new Path<T>(this.segments.subList(0, this.segments.size() - count), this.trailingSlash, this.validator, this.inverse);
        }

        public Path<T> append(String segment) {
            return this.append(List.of(segment), Function.identity(), this.trailingSlash);
        }

        public <U> Path<T> append(Path<U> other) {
            return this.append(other.segments, other.inverse, other.trailingSlash);
        }

        public Path<T> append(List<T> segments) {
            return this.append(segments, this.inverse, this.trailingSlash);
        }

        private <U> Path<T> append(List<U> segments, Function<U, String> inverse, boolean trailingSlash) {
            ArrayList<T> copy = new ArrayList<T>(this.segments);
            for (U segment : segments) {
                copy.add(this.validator.apply(Path.requireNonNormalizable(inverse.apply(segment))));
            }
            return new Path<T>(copy, trailingSlash, this.validator, this.inverse);
        }

        public Path<T> withTrailingSlash() {
            return new Path<T>(this.segments, true, this.validator, this.inverse);
        }

        public Path<T> withoutTrailingSlash() {
            return new Path<T>(this.segments, false, this.validator, this.inverse);
        }

        public List<T> segments() {
            return Collections.unmodifiableList(this.segments);
        }

        private String raw() {
            StringJoiner joiner = new StringJoiner("/", "/", this.trailingSlash ? "/" : "").setEmptyValue(this.trailingSlash ? "/" : "");
            for (T segment : this.segments) {
                joiner.add(URLEncoder.encode(this.inverse.apply(segment), StandardCharsets.UTF_8));
            }
            return joiner.toString();
        }

        public String toString() {
            return "path '" + this.raw() + "'";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Path path = (Path)o;
            return this.trailingSlash == path.trailingSlash && this.segments.equals(path.segments);
        }

        public int hashCode() {
            return Objects.hash(this.segments, this.trailingSlash);
        }
    }

    public static class Query<T> {
        private final Map<T, T> values;
        private final Function<String, T> validator;
        private final Function<T, String> inverse;

        private Query(Map<T, T> values, Function<String, T> validator, Function<T, String> inverse) {
            this.values = Objects.requireNonNull(values);
            this.validator = Objects.requireNonNull(validator);
            this.inverse = Objects.requireNonNull(inverse);
        }

        public static Query<String> empty() {
            return new Query<String>(Map.of(), Function.identity(), Function.identity());
        }

        public static <T extends StringWrapper<T>> Query<T> empty(Function<String, T> validator) {
            return new Query<StringWrapper>(Map.of(), validator, StringWrapper::value);
        }

        public static Query<String> from(Map<String, String> values) {
            return Query.empty().merge(values);
        }

        public static <T extends StringWrapper<T>> Query<T> from(Map<String, String> values, Function<String, T> validator) {
            return Query.empty(validator).merge(values, Function.identity());
        }

        public static <T extends StringWrapper<T>> Query<T> parse(String raw, Function<String, T> validator) {
            return Query.parse(raw, validator, StringWrapper::value);
        }

        public static Query<String> parse(String raw) {
            return Query.parse(raw, Function.identity(), Function.identity());
        }

        private static <T> Query<T> parse(String raw, Function<String, T> validator, Function<T, String> inverse) {
            if (raw == null) {
                return new Query(Map.of(), validator, inverse);
            }
            LinkedHashMap<T, Object> values = new LinkedHashMap<T, Object>();
            for (String pair : raw.split("&")) {
                String value;
                String key;
                int split = pair.indexOf("=");
                if (split == -1) {
                    key = pair;
                    value = null;
                } else {
                    key = pair.substring(0, split);
                    value = pair.substring(split + 1);
                }
                values.put(validator.apply(URLDecoder.decode(key, StandardCharsets.UTF_8)), value == null ? null : (Object)validator.apply(URLDecoder.decode(value, StandardCharsets.UTF_8)));
            }
            return new Query(values, validator, inverse);
        }

        public Query<T> put(String key, String value) {
            LinkedHashMap<T, T> copy = new LinkedHashMap<T, T>(this.values);
            copy.put(Objects.requireNonNull(this.validator.apply(key)), Objects.requireNonNull(this.validator.apply(value)));
            return new Query<T>(copy, this.validator, this.inverse);
        }

        public Query<T> add(String key) {
            LinkedHashMap<T, T> copy = new LinkedHashMap<T, T>(this.values);
            copy.put(Objects.requireNonNull(this.validator.apply(key)), null);
            return new Query<T>(copy, this.validator, this.inverse);
        }

        public Query<T> remove(String key) {
            LinkedHashMap<T, T> copy = new LinkedHashMap<T, T>(this.values);
            copy.remove(Objects.requireNonNull(this.validator.apply(key)));
            return new Query<T>(copy, this.validator, this.inverse);
        }

        public <U> Query<T> merge(Query<U> other) {
            return this.merge(other.values, other.inverse);
        }

        public Query<T> merge(Map<T, T> values) {
            return this.merge(values, this.inverse);
        }

        private <U> Query<T> merge(Map<U, U> values, Function<U, String> inverse) {
            LinkedHashMap<T, T> copy = new LinkedHashMap<T, T>(this.values);
            values.forEach((key, value) -> copy.put(this.validator.apply((String)inverse.apply(Objects.requireNonNull(key, "keys cannot be null"))), value == null ? null : (Object)this.validator.apply((String)inverse.apply(value))));
            return new Query<T>(copy, this.validator, this.inverse);
        }

        public Map<T, T> entries() {
            return Collections.unmodifiableMap(this.values);
        }

        private String raw() {
            StringJoiner joiner = new StringJoiner("&", "?", "").setEmptyValue("");
            this.values.forEach((key, value) -> joiner.add(URLEncoder.encode(this.inverse.apply(key), StandardCharsets.UTF_8) + (String)(value == null ? "" : "=" + URLEncoder.encode(this.inverse.apply(value), StandardCharsets.UTF_8))));
            return joiner.toString();
        }

        public String toString() {
            return "query '" + this.raw() + "'";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Query query = (Query)o;
            return this.values.equals(query.values);
        }

        public int hashCode() {
            return Objects.hash(this.values);
        }
    }
}

