/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class Path {
    private final String pathString;
    private final String[] elements;
    private final Map<String, String> values = new HashMap<String, String>();
    private String rest = "";

    public Path(URI uri) {
        this.pathString = Path.requireNormalized(uri).getRawPath();
        this.elements = Path.splitAbsolutePath(this.pathString, part -> URLDecoder.decode(part, StandardCharsets.UTF_8));
    }

    private boolean matchesInner(String pathSpec) {
        this.values.clear();
        String[] specElements = Path.splitAbsolutePath(pathSpec, Function.identity());
        boolean matchPrefix = false;
        if (specElements.length > 1 && specElements[specElements.length - 1].equals("{*}")) {
            matchPrefix = true;
            specElements = Arrays.copyOf(specElements, specElements.length - 1);
        }
        if (matchPrefix ? this.elements.length < specElements.length : this.elements.length != specElements.length) {
            return false;
        }
        for (int i = 0; i < specElements.length; ++i) {
            if (specElements[i].startsWith("{") && specElements[i].endsWith("}")) {
                this.values.put(specElements[i].substring(1, specElements[i].length() - 1), this.elements[i]);
                continue;
            }
            if (specElements[i].equals(this.elements[i])) continue;
            return false;
        }
        if (matchPrefix) {
            StringBuilder rest = new StringBuilder();
            for (int i = specElements.length; i < this.elements.length; ++i) {
                rest.append(this.elements[i]).append("/");
            }
            if (!this.pathString.endsWith("/") && rest.length() > 0) {
                rest.setLength(rest.length() - 1);
            }
            this.rest = rest.toString();
        }
        return true;
    }

    public boolean matches(String pathSpec) {
        return this.matchesInner(pathSpec);
    }

    public String get(String placeholder) {
        return this.values.get(placeholder);
    }

    public String getRest() {
        return this.rest;
    }

    public String asString() {
        return this.pathString;
    }

    public String toString() {
        return "path '" + String.join((CharSequence)"/", this.elements) + "'";
    }

    private static URI requireNormalized(URI uri) {
        Objects.requireNonNull(uri);
        if (!uri.normalize().equals(uri)) {
            throw new IllegalArgumentException("Expected normalized URI, got '" + uri + "'");
        }
        return uri;
    }

    private static String[] splitAbsolutePath(String path, Function<String, String> partParser) {
        String[] parts;
        for (String part : parts = (String[])Stream.of(path.split("/")).map(partParser).toArray(String[]::new)) {
            if (!part.equals("..")) continue;
            throw new IllegalArgumentException("Expected absolute path, got '" + path + "'");
        }
        return parts;
    }
}

