/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import com.yahoo.container.logging.ConnectionLogEntry;
import com.yahoo.container.logging.LogFileHandler;
import com.yahoo.container.logging.LogWriter;

class ConnectionLogHandler {
    private final LogFileHandler<ConnectionLogEntry> logFileHandler;

    public ConnectionLogHandler(String logDirectoryName, int bufferSize, String clusterName, int queueSize, LogWriter<ConnectionLogEntry> logWriter) {
        this.logFileHandler = new LogFileHandler<ConnectionLogEntry>(LogFileHandler.Compression.ZSTD, bufferSize, String.format("logs/vespa/%s/ConnectionLog.%s.%s", logDirectoryName, clusterName, "%Y%m%d%H%M%S"), "0 60 ...", String.format("ConnectionLog.%s", clusterName), queueSize, "connection-logger", logWriter);
    }

    public void log(ConnectionLogEntry entry) {
        this.logFileHandler.publish(entry);
    }

    public void shutdown() {
        this.logFileHandler.close();
        this.logFileHandler.shutdown();
    }
}

