/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.threadpool;

import com.google.common.util.concurrent.ForwardingExecutorService;
import com.yahoo.container.handler.threadpool.ThreadPoolMetric;
import com.yahoo.container.handler.threadpool.WorkerCompletionTimingThreadPoolExecutor;
import com.yahoo.container.protect.ProcessTerminator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

class ExecutorServiceWrapper
extends ForwardingExecutorService {
    private final WorkerCompletionTimingThreadPoolExecutor wrapped;
    private final ThreadPoolMetric metric;
    private final ProcessTerminator processTerminator;
    private final long maxThreadExecutionTimeMillis;
    private final int queueCapacity;
    private final Thread metricReporter;
    private final boolean threadPoolIsOnlyQ;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    ExecutorServiceWrapper(WorkerCompletionTimingThreadPoolExecutor wrapped, ThreadPoolMetric metric, ProcessTerminator processTerminator, long maxThreadExecutionTimeMillis, String name) {
        this.wrapped = wrapped;
        this.metric = metric;
        this.processTerminator = processTerminator;
        this.maxThreadExecutionTimeMillis = maxThreadExecutionTimeMillis;
        int maxQueueCapacity = wrapped.getQueue().remainingCapacity() + wrapped.getQueue().size();
        this.threadPoolIsOnlyQ = maxQueueCapacity == 0;
        this.queueCapacity = this.threadPoolIsOnlyQ ? wrapped.getMaximumPoolSize() : maxQueueCapacity;
        metric.reportThreadPoolSize(wrapped.getPoolSize());
        metric.reportActiveThreads(wrapped.getActiveCount());
        this.reportMetrics();
        this.metricReporter = new Thread(this::reportMetricsRegularly);
        this.metricReporter.setName(name + "-threadpool-metric-reporter");
        this.metricReporter.start();
    }

    private void reportMetrics() {
        int activeThreads = this.wrapped.getActiveCount();
        this.metric.reportThreadPoolSize(this.wrapped.getPoolSize());
        this.metric.reportActiveThreads(activeThreads);
        int queueSize = this.threadPoolIsOnlyQ ? activeThreads : this.wrapped.getQueue().size();
        this.metric.reportWorkQueueSize(queueSize);
        this.metric.reportWorkQueueCapacity(this.queueCapacity);
    }

    private void reportMetricsRegularly() {
        while (this.timeToReportMetricsAgain(100)) {
            this.reportMetrics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean timeToReportMetricsAgain(int timeoutMS) {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            if (!this.closed.get()) {
                try {
                    this.closed.wait(timeoutMS);
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }
        return !this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        super.shutdown();
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            this.closed.set(true);
            this.closed.notify();
        }
        try {
            this.metricReporter.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void execute(Runnable command) {
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException e) {
            this.metric.reportRejectRequest();
            long timeSinceLastReturnedThreadMillis = System.currentTimeMillis() - this.wrapped.lastThreadAssignmentTimeMillis;
            if (timeSinceLastReturnedThreadMillis > this.maxThreadExecutionTimeMillis) {
                this.processTerminator.logAndDie("No worker threads have been available for " + timeSinceLastReturnedThreadMillis + " ms. Shutting down.", true);
            }
            throw e;
        }
    }

    protected ExecutorService delegate() {
        return this.wrapped;
    }
}

