/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.metrics;

import ai.vespa.util.http.hc4.VespaHttpClientBuilder;
import com.google.inject.Inject;
import com.yahoo.container.handler.metrics.ErrorResponse;
import com.yahoo.container.handler.metrics.HttpHandlerBase;
import com.yahoo.container.handler.metrics.JsonResponse;
import com.yahoo.container.handler.metrics.MetricsProxyApiConfig;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.restapi.Path;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;

public class MetricsV2Handler
extends HttpHandlerBase {
    public static final String V2_PATH = "/metrics/v2";
    static final String VALUES_PATH = "/metrics/v2/values";
    private static final int HTTP_CONNECT_TIMEOUT = 5000;
    private static final int HTTP_SOCKET_TIMEOUT = 30000;
    private final String metricsProxyUri;
    private final HttpClient httpClient = MetricsV2Handler.createHttpClient();

    @Inject
    public MetricsV2Handler(Executor executor, MetricsProxyApiConfig config) {
        super(executor);
        this.metricsProxyUri = "http://localhost:" + config.metricsPort() + config.metricsApiPath();
    }

    @Override
    protected Optional<HttpResponse> doHandle(URI requestUri, Path apiPath, String consumer) {
        if (apiPath.matches(V2_PATH)) {
            return Optional.of(this.resourceListResponse(requestUri, List.of(VALUES_PATH)));
        }
        if (apiPath.matches(VALUES_PATH)) {
            return Optional.of(this.valuesResponse(consumer));
        }
        return Optional.empty();
    }

    private JsonResponse valuesResponse(String consumer) {
        try {
            String uri = this.metricsProxyUri + MetricsV2Handler.consumerQuery(consumer);
            String metricsJson = (String)this.httpClient.execute((HttpUriRequest)new HttpGet(uri), (ResponseHandler)new BasicResponseHandler());
            return new JsonResponse(200, metricsJson);
        }
        catch (IOException e) {
            this.log.warning("Unable to retrieve metrics from " + this.metricsProxyUri + ": " + Exceptions.toMessageString((Throwable)e));
            return new ErrorResponse(500, e.getMessage());
        }
    }

    private static CloseableHttpClient createHttpClient() {
        return VespaHttpClientBuilder.create().setUserAgent("application-metrics-retriever").setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(30000).build()).build();
    }

    static String consumerQuery(String consumer) {
        return consumer == null || consumer.isEmpty() ? "" : "?consumer=" + consumer;
    }
}

