/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di.componentgraph.cycle;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Graph<T> {
    private final Map<T, LinkedHashSet<T>> adjMap = new LinkedHashMap<T, LinkedHashSet<T>>();

    public void edge(T from, T to) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("Null vertices are not allowed, edge: " + from + "->" + to);
        }
        this.adjMap.computeIfAbsent(from, k -> new LinkedHashSet()).add(to);
        this.adjMap.computeIfAbsent(to, k -> new LinkedHashSet());
    }

    Set<T> getVertices() {
        return this.adjMap.keySet();
    }

    Set<T> getAdjacent(T vertex) {
        return this.adjMap.get(vertex);
    }

    private void throwIfMissingVertex(T vertex) {
        if (!this.adjMap.containsKey(vertex)) {
            throw new IllegalArgumentException("No such vertex in the graph: " + vertex);
        }
    }
}

