/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.google.inject.Inject;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.logging.ConnectionLog;
import com.yahoo.container.logging.RequestLog;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.jdisc.http.server.jetty.AccessLogRequestLog;
import com.yahoo.jdisc.http.server.jetty.ConnectionMetricAggregator;
import com.yahoo.jdisc.http.server.jetty.ConnectorFactory;
import com.yahoo.jdisc.http.server.jetty.FilterBindings;
import com.yahoo.jdisc.http.server.jetty.HealthCheckProxyHandler;
import com.yahoo.jdisc.http.server.jetty.HttpResponseStatisticsCollector;
import com.yahoo.jdisc.http.server.jetty.JDiscContext;
import com.yahoo.jdisc.http.server.jetty.JDiscHttpServlet;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import com.yahoo.jdisc.http.server.jetty.Janitor;
import com.yahoo.jdisc.http.server.jetty.JettyConnectionLogger;
import com.yahoo.jdisc.http.server.jetty.SecuredRedirectHandler;
import com.yahoo.jdisc.http.server.jetty.ServerMetricReporter;
import com.yahoo.jdisc.http.server.jetty.TlsClientAuthenticationEnforcer;
import com.yahoo.jdisc.service.AbstractServerProvider;
import com.yahoo.jdisc.service.CurrentContainer;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.management.remote.JMXServiceURL;
import javax.servlet.Servlet;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.jmx.ConnectorServer;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHttpOutputInterceptor;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.log.JavaUtilLog;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class JettyHttpServer
extends AbstractServerProvider {
    private static final Logger log = Logger.getLogger(JettyHttpServer.class.getName());
    private final Server server;
    private final List<Integer> listenedPorts = new ArrayList<Integer>();
    private final ServerMetricReporter metricsReporter;

    @Inject
    public JettyHttpServer(CurrentContainer container, Metric metric, ServerConfig serverConfig, FilterBindings filterBindings, Janitor janitor, ComponentRegistry<ConnectorFactory> connectorFactories, RequestLog requestLog, ConnectionLog connectionLog) {
        super(container);
        if (connectorFactories.allComponents().isEmpty()) {
            throw new IllegalArgumentException("No connectors configured.");
        }
        JettyHttpServer.initializeJettyLogging();
        this.server = new Server();
        this.server.setStopTimeout((long)(serverConfig.stopTimeout() * 1000.0));
        this.server.setRequestLog((org.eclipse.jetty.server.RequestLog)new AccessLogRequestLog(requestLog, serverConfig.accessLog()));
        JettyHttpServer.setupJmx(this.server, serverConfig);
        JettyHttpServer.configureJettyThreadpool(this.server, serverConfig);
        JettyConnectionLogger connectionLogger = new JettyConnectionLogger(serverConfig.connectionLog(), connectionLog);
        ConnectionMetricAggregator connectionMetricAggregator = new ConnectionMetricAggregator(serverConfig, metric);
        for (ConnectorFactory connectorFactory : connectorFactories.allComponents()) {
            ConnectorConfig connectorConfig = connectorFactory.getConnectorConfig();
            this.server.addConnector((Connector)connectorFactory.createConnector(metric, this.server, connectionLogger, connectionMetricAggregator));
            this.listenedPorts.add(connectorConfig.listenPort());
        }
        JDiscContext jDiscContext = new JDiscContext(filterBindings, container, janitor, metric, serverConfig);
        ServletHolder jdiscServlet = new ServletHolder((Servlet)new JDiscHttpServlet(jDiscContext));
        List<JDiscServerConnector> connectors = Arrays.stream(this.server.getConnectors()).map(JDiscServerConnector.class::cast).collect(Collectors.toList());
        this.server.setHandler((Handler)this.getHandlerCollection(serverConfig, connectors, jdiscServlet));
        this.metricsReporter = new ServerMetricReporter(metric, this.server);
    }

    private static void initializeJettyLogging() {
        try {
            Log.setLog((org.eclipse.jetty.util.log.Logger)new JavaUtilLog());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize logging framework for Jetty");
        }
    }

    private static void setupJmx(Server server, ServerConfig serverConfig) {
        if (serverConfig.jmx().enabled()) {
            System.setProperty("java.rmi.server.hostname", "localhost");
            server.addBean((Object)new MBeanContainer(ManagementFactory.getPlatformMBeanServer()));
            server.addBean((Object)new ConnectorServer(JettyHttpServer.createJmxLoopbackOnlyServiceUrl(serverConfig.jmx().listenPort()), "org.eclipse.jetty.jmx:name=rmiconnectorserver"));
        }
    }

    private static void configureJettyThreadpool(Server server, ServerConfig config) {
        int cpus = Runtime.getRuntime().availableProcessors();
        QueuedThreadPool pool = (QueuedThreadPool)server.getThreadPool();
        int maxThreads = config.maxWorkerThreads() > 0 ? config.maxWorkerThreads() : 16 + cpus;
        pool.setMaxThreads(maxThreads);
        int minThreads = config.minWorkerThreads() >= 0 ? config.minWorkerThreads() : 16 + cpus;
        pool.setMinThreads(minThreads);
        log.info(String.format("Threadpool size: min=%d, max=%d", minThreads, maxThreads));
    }

    private static JMXServiceURL createJmxLoopbackOnlyServiceUrl(int port) {
        try {
            return new JMXServiceURL("rmi", "localhost", port, "/jndi/rmi://localhost:" + port + "/jmxrmi");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private HandlerCollection getHandlerCollection(ServerConfig serverConfig, List<JDiscServerConnector> connectors, ServletHolder jdiscServlet) {
        ServletContextHandler servletContextHandler = this.createServletContextHandler();
        servletContextHandler.addServlet(jdiscServlet, "/*");
        List<ConnectorConfig> connectorConfigs = connectors.stream().map(JDiscServerConnector::connectorConfig).collect(Collectors.toList());
        SecuredRedirectHandler secureRedirectHandler = new SecuredRedirectHandler(connectorConfigs);
        secureRedirectHandler.setHandler((Handler)servletContextHandler);
        HealthCheckProxyHandler proxyHandler = new HealthCheckProxyHandler(connectors);
        proxyHandler.setHandler((Handler)secureRedirectHandler);
        TlsClientAuthenticationEnforcer authEnforcer = new TlsClientAuthenticationEnforcer(connectorConfigs);
        authEnforcer.setHandler((Handler)proxyHandler);
        GzipHandler gzipHandler = this.newGzipHandler(serverConfig);
        gzipHandler.setHandler((Handler)authEnforcer);
        HttpResponseStatisticsCollector statisticsCollector = new HttpResponseStatisticsCollector(serverConfig.metric().monitoringHandlerPaths(), serverConfig.metric().searchHandlerPaths());
        statisticsCollector.setHandler((Handler)gzipHandler);
        for (String agent : serverConfig.metric().ignoredUserAgents()) {
            statisticsCollector.ignoreUserAgent(agent);
        }
        StatisticsHandler statisticsHandler = this.newStatisticsHandler();
        statisticsHandler.setHandler((Handler)statisticsCollector);
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{statisticsHandler});
        return handlerCollection;
    }

    private ServletContextHandler createServletContextHandler() {
        ServletContextHandler servletContextHandler = new ServletContextHandler(0);
        servletContextHandler.setContextPath("/");
        servletContextHandler.setDisplayName(JettyHttpServer.getDisplayName(this.listenedPorts));
        return servletContextHandler;
    }

    private static String getDisplayName(List<Integer> ports) {
        return ports.stream().map(Object::toString).collect(Collectors.joining(":"));
    }

    public void start() {
        try {
            this.server.start();
            this.metricsReporter.start();
            this.logEffectiveSslConfiguration();
        }
        catch (Exception e) {
            if (e instanceof IOException && e.getCause() instanceof BindException) {
                throw new RuntimeException("Failed to start server due to BindException. ListenPorts = " + this.listenedPorts.toString(), e.getCause());
            }
            throw new RuntimeException("Failed to start server.", e);
        }
    }

    private void logEffectiveSslConfiguration() {
        if (!this.server.isStarted()) {
            throw new IllegalStateException();
        }
        for (Connector connector : this.server.getConnectors()) {
            ServerConnector serverConnector = (ServerConnector)connector;
            int localPort = serverConnector.getLocalPort();
            SslConnectionFactory sslConnectionFactory = (SslConnectionFactory)serverConnector.getConnectionFactory(SslConnectionFactory.class);
            if (sslConnectionFactory == null) continue;
            SslContextFactory sslContextFactory = sslConnectionFactory.getSslContextFactory();
            String protocols = Arrays.toString(sslContextFactory.getSelectedProtocols());
            String cipherSuites = Arrays.toString(sslContextFactory.getSelectedCipherSuites());
            log.info(String.format("TLS for port '%d': %s with %s", localPort, protocols, cipherSuites));
        }
    }

    public void close() {
        try {
            log.log(Level.INFO, String.format("Shutting down Jetty server (graceful=%b, timeout=%.1fs)", this.isGracefulShutdownEnabled(), (double)this.server.getStopTimeout() / 1000.0));
            long start = System.currentTimeMillis();
            this.server.stop();
            log.log(Level.INFO, String.format("Jetty server shutdown completed in %.3f seconds", (double)(System.currentTimeMillis() - start) / 1000.0));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Jetty server shutdown threw an unexpected exception.", e);
        }
        this.metricsReporter.shutdown();
    }

    private boolean isGracefulShutdownEnabled() {
        return this.server.getChildHandlersByClass(StatisticsHandler.class).length > 0 && this.server.getStopTimeout() > 0L;
    }

    public int getListenPort() {
        return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
    }

    Server server() {
        return this.server;
    }

    private StatisticsHandler newStatisticsHandler() {
        StatisticsHandler statisticsHandler = new StatisticsHandler();
        statisticsHandler.statsReset();
        return statisticsHandler;
    }

    private GzipHandler newGzipHandler(ServerConfig serverConfig) {
        GzipHandlerWithVaryHeaderFixed gzipHandler = new GzipHandlerWithVaryHeaderFixed();
        gzipHandler.setCompressionLevel(serverConfig.responseCompressionLevel());
        gzipHandler.setInflateBufferSize(8192);
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT", "PATCH"});
        return gzipHandler;
    }

    private static class GzipHandlerWithVaryHeaderFixed
    extends GzipHandler {
        private GzipHandlerWithVaryHeaderFixed() {
        }

        public HttpField getVaryField() {
            return GzipHttpOutputInterceptor.VARY_ACCEPT_ENCODING;
        }
    }
}

