/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.threadpool;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.handler.threadpool.ContainerThreadPool;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.container.handler.threadpool.ExecutorServiceWrapper;
import com.yahoo.container.handler.threadpool.ThreadPoolMetric;
import com.yahoo.container.handler.threadpool.WorkerCompletionTimingThreadPoolExecutor;
import com.yahoo.container.protect.ProcessTerminator;
import com.yahoo.jdisc.Metric;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class DefaultContainerThreadpool
extends AbstractComponent
implements AutoCloseable,
ContainerThreadPool {
    private static final Logger log = Logger.getLogger(DefaultContainerThreadpool.class.getName());
    private static final int MIN_QUEUE_SIZE = 650;
    private static final int MIN_THREADS_WHEN_SCALE_FACTOR = 8;
    private final ExecutorServiceWrapper threadpool;

    @Inject
    public DefaultContainerThreadpool(ContainerThreadpoolConfig config, Metric metric) {
        this(config, metric, new ProcessTerminator());
    }

    public DefaultContainerThreadpool(ContainerThreadpoolConfig config, Metric metric, ProcessTerminator processTerminator) {
        this(config, metric, processTerminator, Runtime.getRuntime().availableProcessors());
    }

    DefaultContainerThreadpool(ContainerThreadpoolConfig config, Metric metric, ProcessTerminator processTerminator, int cpus) {
        String name = config.name();
        int maxThreads = DefaultContainerThreadpool.maxThreads(config, cpus);
        int minThreads = DefaultContainerThreadpool.minThreads(config, maxThreads, cpus);
        int queueSize = this.queueSize(config, maxThreads);
        log.info(String.format("Threadpool '%s': min=%d, max=%d, queue=%d", name, minThreads, maxThreads, queueSize));
        ThreadPoolMetric threadPoolMetric = new ThreadPoolMetric(metric, name);
        WorkerCompletionTimingThreadPoolExecutor executor = new WorkerCompletionTimingThreadPoolExecutor(minThreads, maxThreads, (long)((int)config.keepAliveTime() * 1000), TimeUnit.MILLISECONDS, DefaultContainerThreadpool.createQueue(queueSize), ThreadFactoryFactory.getThreadFactory((String)name), threadPoolMetric);
        executor.prestartAllCoreThreads();
        this.threadpool = new ExecutorServiceWrapper(executor, threadPoolMetric, processTerminator, (long)config.maxThreadExecutionTimeSeconds() * 1000L, name);
    }

    @Override
    public Executor executor() {
        return this.threadpool;
    }

    @Override
    public void close() {
        this.closeInternal();
    }

    public void deconstruct() {
        this.closeInternal();
        super.deconstruct();
    }

    private void closeInternal() {
        boolean terminated;
        this.threadpool.shutdown();
        try {
            terminated = this.threadpool.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        if (!terminated) {
            this.threadpool.shutdownNow();
        }
    }

    private static BlockingQueue<Runnable> createQueue(int size) {
        return size == 0 ? new SynchronousQueue(false) : new ArrayBlockingQueue(size);
    }

    private static int maxThreads(ContainerThreadpoolConfig config, int cpus) {
        if (config.maxThreads() > 0) {
            return config.maxThreads();
        }
        if (config.maxThreads() == 0) {
            return 4 * cpus;
        }
        return Math.max(8, Math.abs(config.maxThreads()) * cpus);
    }

    private static int minThreads(ContainerThreadpoolConfig config, int max, int cpus) {
        int threads = config.minThreads() > 0 ? config.minThreads() : (config.minThreads() == 0 ? 4 * cpus : Math.max(8, Math.abs(config.minThreads()) * cpus));
        return Math.min(threads, max);
    }

    private int queueSize(ContainerThreadpoolConfig config, int maxThreads) {
        return config.queueSize() >= 0 ? config.queueSize() : Math.max(650, Math.abs(config.queueSize()) * maxThreads);
    }
}

