/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import com.fasterxml.jackson.core.JsonGenerator;
import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.simple.JsonRender;
import com.yahoo.yolean.trace.TraceNode;
import com.yahoo.yolean.trace.TraceVisitor;
import java.io.IOException;

public class TraceRenderer
extends TraceVisitor {
    private static final String TRACE_CHILDREN = "children";
    private static final String TRACE_MESSAGE = "message";
    private static final String TRACE_TIMESTAMP = "timestamp";
    private static final String TRACE = "trace";
    private final long basetime;
    private final JsonGenerator generator;
    private final FieldConsumer fieldConsumer;
    private boolean hasFieldName = false;
    int emittedChildNesting = 0;
    int currentChildNesting = 0;
    private boolean insideOpenObject = false;

    TraceRenderer(JsonGenerator generator, long basetime) {
        this(generator, new Consumer(generator), basetime);
    }

    public TraceRenderer(JsonGenerator generator, FieldConsumer consumer, long basetime) {
        this.generator = generator;
        this.fieldConsumer = consumer;
        this.basetime = basetime;
    }

    public void entering(TraceNode node) {
        ++this.currentChildNesting;
    }

    public void leaving(TraceNode node) {
        this.conditionalEndObject();
        if (this.currentChildNesting == this.emittedChildNesting) {
            try {
                this.generator.writeEndArray();
                this.generator.writeEndObject();
            }
            catch (IOException e) {
                throw new TraceRenderWrapper(e);
            }
            --this.emittedChildNesting;
        }
        --this.currentChildNesting;
    }

    public void visit(TraceNode node) {
        try {
            this.doVisit(node.timestamp(), node.payload(), node.children().iterator().hasNext());
        }
        catch (IOException e) {
            throw new TraceRenderWrapper(e);
        }
    }

    private void doVisit(long timestamp, Object payload, boolean hasChildren) throws IOException {
        boolean dirty = false;
        if (timestamp != 0L) {
            this.header();
            this.generator.writeStartObject();
            this.generator.writeNumberField(TRACE_TIMESTAMP, timestamp - this.basetime);
            dirty = true;
        }
        if (payload != null) {
            if (!dirty) {
                this.header();
                this.generator.writeStartObject();
            }
            this.generator.writeFieldName(TRACE_MESSAGE);
            this.fieldConsumer.accept(payload);
            dirty = true;
        }
        if (dirty) {
            if (!hasChildren) {
                this.generator.writeEndObject();
            } else {
                this.setInsideOpenObject(true);
            }
        }
    }

    private void header() {
        this.fieldName();
        for (int i = 0; i < this.currentChildNesting - this.emittedChildNesting; ++i) {
            this.startChildArray();
        }
        this.emittedChildNesting = this.currentChildNesting;
    }

    private void startChildArray() {
        try {
            this.conditionalStartObject();
            this.generator.writeArrayFieldStart(TRACE_CHILDREN);
        }
        catch (IOException e) {
            throw new TraceRenderWrapper(e);
        }
    }

    private void conditionalStartObject() throws IOException {
        if (!this.isInsideOpenObject()) {
            this.generator.writeStartObject();
        } else {
            this.setInsideOpenObject(false);
        }
    }

    private void conditionalEndObject() {
        if (this.isInsideOpenObject()) {
            try {
                this.generator.writeEndObject();
                this.setInsideOpenObject(false);
            }
            catch (IOException e) {
                throw new TraceRenderWrapper(e);
            }
        }
    }

    private void fieldName() {
        if (this.hasFieldName) {
            return;
        }
        try {
            this.generator.writeFieldName(TRACE);
        }
        catch (IOException e) {
            throw new TraceRenderWrapper(e);
        }
        this.hasFieldName = true;
    }

    boolean isInsideOpenObject() {
        return this.insideOpenObject;
    }

    void setInsideOpenObject(boolean insideOpenObject) {
        this.insideOpenObject = insideOpenObject;
    }

    public static final class TraceRenderWrapper
    extends RuntimeException {
        private static final long serialVersionUID = 2L;

        TraceRenderWrapper(IOException wrapped) {
            super(wrapped);
        }
    }

    private static class Consumer
    implements FieldConsumer {
        private final JsonGenerator generator;

        Consumer(JsonGenerator generator) {
            this.generator = generator;
        }

        @Override
        public void accept(Object object) throws IOException {
            if (object instanceof Inspectable) {
                this.renderInspectorDirect(((Inspectable)object).inspect());
            } else {
                this.generator.writeObject(object);
            }
        }

        private void renderInspectorDirect(Inspector data) throws IOException {
            StringBuilder intermediate = new StringBuilder();
            JsonRender.render((Inspectable)data, (StringBuilder)intermediate, (boolean)true);
            this.generator.writeRawValue(intermediate.toString());
        }
    }

    public static interface FieldConsumer {
        public void accept(Object var1) throws IOException;
    }
}

