/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.container.jdisc.state.FileWrapper;
import com.yahoo.vespa.defaults.Defaults;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.stream.Stream;

public class CoredumpGatherer {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final Path COREDUMP_PATH = Path.of(Defaults.getDefaults().underVespaHome("var/crash/processing"), new String[0]);

    public static JsonNode gatherCoredumpMetrics(FileWrapper fileWrapper) {
        int coredumps = CoredumpGatherer.getNumberOfCoredumps(fileWrapper);
        ObjectNode packet = jsonMapper.createObjectNode();
        packet.put("status_code", coredumps == 0 ? 0 : 1);
        packet.put("status_msg", coredumps == 0 ? "OK" : String.format("Found %d coredump(s)", coredumps));
        packet.put("timestamp", Instant.now().getEpochSecond());
        packet.put("application", "system-coredumps-processing");
        return packet;
    }

    private static int getNumberOfCoredumps(FileWrapper fileWrapper) {
        int n;
        block9: {
            Stream<Path> stream = fileWrapper.walkTree(COREDUMP_PATH);
            try {
                n = (int)stream.filter(fileWrapper::isRegularFile).count();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return 0;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return n;
    }
}

