/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.StringNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public final class ServletPathsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "c9f25f7087ba57a511afbffe7acbac46";
    public static final String CONFIG_DEF_NAME = "servlet-paths";
    public static final String CONFIG_DEF_NAMESPACE = "jdisc.http";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=jdisc.http", "servlets{}.path string"};
    private final Map<String, Servlets> servlets;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ServletPathsConfig(Builder builder) {
        this(builder, true);
    }

    private ServletPathsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for servlet-paths must be initialized: " + builder.__uninitialized);
        }
        this.servlets = Servlets.createMap(builder.servlets);
    }

    public Map<String, Servlets> servlets() {
        return Collections.unmodifiableMap(this.servlets);
    }

    public Servlets servlets(String key) {
        return this.servlets.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ServletPathsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Servlets
    extends InnerNode {
        private final StringNode path;

        public Servlets(Builder builder) {
            this(builder, true);
        }

        private Servlets(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for servlet-paths.servlets{} must be initialized: " + builder.__uninitialized);
            }
            this.path = builder.path == null ? new StringNode() : new StringNode(builder.path);
        }

        public String path() {
            return this.path.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Servlets newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("servlets");
            return changes;
        }

        private static Map<String, Servlets> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Servlets> ret = new LinkedHashMap<String, Servlets>();
            for (String key : builders.keySet()) {
                ret.put(key, new Servlets(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("path"));
            private String path = null;

            public Builder() {
            }

            public Builder(Servlets config) {
                this.path(config.path());
            }

            private Builder override(Builder __superior) {
                if (__superior.path != null) {
                    this.path(__superior.path);
                }
                return this;
            }

            public Builder path(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.path = __value;
                this.__uninitialized.remove("path");
                return this;
            }

            public Servlets build() {
                return new Servlets(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Map<String, Servlets.Builder> servlets = new LinkedHashMap<String, Servlets.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ServletPathsConfig config) {
            for (Map.Entry<String, Servlets> __entry : config.servlets().entrySet()) {
                this.servlets(__entry.getKey(), new Servlets.Builder(__entry.getValue()));
            }
        }

        private Builder override(Builder __superior) {
            this.servlets(__superior.servlets);
            return this;
        }

        public Builder servlets(String __key, Servlets.Builder __value) {
            this.servlets.put(__key, __value);
            return this;
        }

        public Builder servlets(Map<String, Servlets.Builder> __values) {
            this.servlets.putAll(__values);
            return this;
        }

        public Builder servlets(String __key, Consumer<Servlets.Builder> __func) {
            Servlets.Builder __inner = new Servlets.Builder();
            __func.accept(__inner);
            this.servlets.put(__key, __inner);
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ServletPathsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ServletPathsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ServletPathsConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ServletPathsConfig build() {
            return new ServletPathsConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

