/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.threadpool;

import com.yahoo.jdisc.Metric;
import java.util.Map;

class ThreadPoolMetric {
    private static final String THREAD_POOL_NAME_DIMENSION = "threadpool";
    private final Metric metric;
    private final Metric.Context defaultContext;
    private final String threadPoolName;

    ThreadPoolMetric(Metric metric, String threadPoolName) {
        this.metric = metric;
        this.threadPoolName = threadPoolName;
        this.defaultContext = metric.createContext(Map.of(THREAD_POOL_NAME_DIMENSION, threadPoolName));
    }

    void reportRejectRequest() {
        this.metric.add("serverRejectedRequests", (Number)1L, this.defaultContext);
    }

    void reportThreadPoolSize(long size) {
        this.metric.set("serverThreadPoolSize", (Number)size, this.defaultContext);
    }

    void reportActiveThreads(long threads) {
        this.metric.set("serverActiveThreads", (Number)threads, this.defaultContext);
    }

    void reportWorkQueueCapacity(long capacity) {
        this.metric.set("jdisc.thread_pool.work_queue.capacity", (Number)capacity, this.defaultContext);
    }

    void reportWorkQueueSize(long size) {
        this.metric.set("jdisc.thread_pool.work_queue.size", (Number)size, this.defaultContext);
    }

    void reportUnhandledException(Throwable t) {
        Metric.Context ctx = this.metric.createContext(Map.of(THREAD_POOL_NAME_DIMENSION, this.threadPoolName, "exception", t.getClass().getSimpleName()));
        this.metric.set("jdisc.thread_pool.unhandled_exceptions", (Number)1L, ctx);
    }
}

