/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.container.di.CloudSubscriber;
import com.yahoo.container.di.config.Subscriber;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.vespa.config.ConfigKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;

public class CloudSubscriberFactory
implements SubscriberFactory {
    private final ConfigSource configSource;
    private final Map<CloudSubscriber, Integer> activeSubscribers = new WeakHashMap<CloudSubscriber, Integer>();
    private Optional<Long> testGeneration = Optional.empty();

    public CloudSubscriberFactory(ConfigSource configSource) {
        this.configSource = configSource;
    }

    @Override
    public Subscriber getSubscriber(Set<? extends ConfigKey<?>> configKeys, String name) {
        HashSet<ConfigKey<ConfigInstance>> subscriptionKeys = new HashSet<ConfigKey<ConfigInstance>>();
        Iterator<ConfigKey<?>> iterator = configKeys.iterator();
        while (iterator.hasNext()) {
            ConfigKey<?> key;
            ConfigKey<?> invariant = key = iterator.next();
            subscriptionKeys.add(invariant);
        }
        CloudSubscriber subscriber = new CloudSubscriber(name, this.configSource, subscriptionKeys);
        this.testGeneration.ifPresent(arg_0 -> ((ConfigSubscriber)subscriber.getSubscriber()).reload(arg_0));
        this.activeSubscribers.put(subscriber, 0);
        return subscriber;
    }

    @Override
    public void reloadActiveSubscribers(long generation) {
        this.testGeneration = Optional.of(generation);
        ArrayList<CloudSubscriber> subscribers = new ArrayList<CloudSubscriber>(this.activeSubscribers.keySet());
        subscribers.forEach(s -> s.getSubscriber().reload(generation));
    }

    public static class Provider
    implements com.google.inject.Provider<SubscriberFactory> {
        public SubscriberFactory get() {
            return new CloudSubscriberFactory((ConfigSource)ConfigSourceSet.createDefault());
        }
    }
}

