/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class ServerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "78c9262aa2b9b15e4cb73c417717e373";
    public static final String CONFIG_DEF_NAME = "server";
    public static final String CONFIG_DEF_NAMESPACE = "jdisc.http";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=jdisc.http", "developerMode bool default=false", "responseCompressionLevel int default=6", "httpKeepAliveEnabled bool default=true", "maxKeepAliveRequests int default=0", "removeRawPostBodyForWwwUrlEncodedPost bool default=false", "filter[].id string", "filter[].binding string", "defaultFilters[].filterId string", "defaultFilters[].localPort int", "strictFiltering bool default = false", "maxWorkerThreads int default = 200", "minWorkerThreads int default = 8", "stopTimeout double default = 30.0", "jmx.enabled bool default = false", "jmx.listenPort int default = 1099", "metric.monitoringHandlerPaths[] string", "metric.searchHandlerPaths[] string", "accessLog.remoteAddressHeaders[] string", "accessLog.remotePortHeaders[] string", "connectionLog.enabled bool default=false"};
    private final BooleanNode developerMode;
    private final IntegerNode responseCompressionLevel;
    private final BooleanNode httpKeepAliveEnabled;
    private final IntegerNode maxKeepAliveRequests;
    private final BooleanNode removeRawPostBodyForWwwUrlEncodedPost;
    private final InnerNodeVector<Filter> filter;
    private final InnerNodeVector<DefaultFilters> defaultFilters;
    private final BooleanNode strictFiltering;
    private final IntegerNode maxWorkerThreads;
    private final IntegerNode minWorkerThreads;
    private final DoubleNode stopTimeout;
    private final Jmx jmx;
    private final Metric metric;
    private final AccessLog accessLog;
    private final ConnectionLog connectionLog;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ServerConfig(Builder builder) {
        this(builder, true);
    }

    private ServerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for server must be initialized: " + builder.__uninitialized);
        }
        this.developerMode = builder.developerMode == null ? new BooleanNode(false) : new BooleanNode(builder.developerMode.booleanValue());
        this.responseCompressionLevel = builder.responseCompressionLevel == null ? new IntegerNode(6) : new IntegerNode(builder.responseCompressionLevel.intValue());
        this.httpKeepAliveEnabled = builder.httpKeepAliveEnabled == null ? new BooleanNode(true) : new BooleanNode(builder.httpKeepAliveEnabled.booleanValue());
        this.maxKeepAliveRequests = builder.maxKeepAliveRequests == null ? new IntegerNode(0) : new IntegerNode(builder.maxKeepAliveRequests.intValue());
        this.removeRawPostBodyForWwwUrlEncodedPost = builder.removeRawPostBodyForWwwUrlEncodedPost == null ? new BooleanNode(false) : new BooleanNode(builder.removeRawPostBodyForWwwUrlEncodedPost.booleanValue());
        this.filter = Filter.createVector(builder.filter);
        this.defaultFilters = DefaultFilters.createVector(builder.defaultFilters);
        this.strictFiltering = builder.strictFiltering == null ? new BooleanNode(false) : new BooleanNode(builder.strictFiltering.booleanValue());
        this.maxWorkerThreads = builder.maxWorkerThreads == null ? new IntegerNode(200) : new IntegerNode(builder.maxWorkerThreads.intValue());
        this.minWorkerThreads = builder.minWorkerThreads == null ? new IntegerNode(8) : new IntegerNode(builder.minWorkerThreads.intValue());
        this.stopTimeout = builder.stopTimeout == null ? new DoubleNode(30.0) : new DoubleNode(builder.stopTimeout.doubleValue());
        this.jmx = new Jmx(builder.jmx, throwIfUninitialized);
        this.metric = new Metric(builder.metric, throwIfUninitialized);
        this.accessLog = new AccessLog(builder.accessLog, throwIfUninitialized);
        this.connectionLog = new ConnectionLog(builder.connectionLog, throwIfUninitialized);
    }

    public boolean developerMode() {
        return this.developerMode.value();
    }

    public int responseCompressionLevel() {
        return this.responseCompressionLevel.value();
    }

    public boolean httpKeepAliveEnabled() {
        return this.httpKeepAliveEnabled.value();
    }

    public int maxKeepAliveRequests() {
        return this.maxKeepAliveRequests.value();
    }

    public boolean removeRawPostBodyForWwwUrlEncodedPost() {
        return this.removeRawPostBodyForWwwUrlEncodedPost.value();
    }

    public List<Filter> filter() {
        return this.filter;
    }

    public Filter filter(int i) {
        return (Filter)((Object)this.filter.get(i));
    }

    public List<DefaultFilters> defaultFilters() {
        return this.defaultFilters;
    }

    public DefaultFilters defaultFilters(int i) {
        return (DefaultFilters)((Object)this.defaultFilters.get(i));
    }

    public boolean strictFiltering() {
        return this.strictFiltering.value();
    }

    public int maxWorkerThreads() {
        return this.maxWorkerThreads.value();
    }

    public int minWorkerThreads() {
        return this.minWorkerThreads.value();
    }

    public double stopTimeout() {
        return this.stopTimeout.value();
    }

    public Jmx jmx() {
        return this.jmx;
    }

    public Metric metric() {
        return this.metric;
    }

    public AccessLog accessLog() {
        return this.accessLog;
    }

    public ConnectionLog connectionLog() {
        return this.connectionLog;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ServerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class ConnectionLog
    extends InnerNode {
        private final BooleanNode enabled;

        public ConnectionLog(Builder builder) {
            this(builder, true);
        }

        private ConnectionLog(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for server.connectionLog must be initialized: " + builder.__uninitialized);
            }
            this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
        }

        public boolean enabled() {
            return this.enabled.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(ConnectionLog newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("connectionLog");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean enabled = null;

            public Builder() {
            }

            public Builder(ConnectionLog config) {
                this.enabled(config.enabled());
            }

            private Builder override(Builder __superior) {
                if (__superior.enabled != null) {
                    this.enabled(__superior.enabled);
                }
                return this;
            }

            public Builder enabled(boolean __value) {
                this.enabled = __value;
                return this;
            }

            private Builder enabled(String __value) {
                return this.enabled(Boolean.valueOf(__value));
            }

            public ConnectionLog build() {
                return new ConnectionLog(this);
            }
        }
    }

    public static final class AccessLog
    extends InnerNode {
        private final LeafNodeVector<String, StringNode> remoteAddressHeaders;
        private final LeafNodeVector<String, StringNode> remotePortHeaders;

        public AccessLog(Builder builder) {
            this(builder, true);
        }

        private AccessLog(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for server.accessLog must be initialized: " + builder.__uninitialized);
            }
            this.remoteAddressHeaders = new LeafNodeVector(builder.remoteAddressHeaders, (LeafNode)new StringNode());
            this.remotePortHeaders = new LeafNodeVector(builder.remotePortHeaders, (LeafNode)new StringNode());
        }

        public List<String> remoteAddressHeaders() {
            return this.remoteAddressHeaders.asList();
        }

        public String remoteAddressHeaders(int i) {
            return ((StringNode)this.remoteAddressHeaders.get(i)).value();
        }

        public List<String> remotePortHeaders() {
            return this.remotePortHeaders.asList();
        }

        public String remotePortHeaders(int i) {
            return ((StringNode)this.remotePortHeaders.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(AccessLog newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("accessLog");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public List<String> remoteAddressHeaders = new ArrayList<String>();
            public List<String> remotePortHeaders = new ArrayList<String>();

            public Builder() {
            }

            public Builder(AccessLog config) {
                this.remoteAddressHeaders(config.remoteAddressHeaders());
                this.remotePortHeaders(config.remotePortHeaders());
            }

            private Builder override(Builder __superior) {
                if (!__superior.remoteAddressHeaders.isEmpty()) {
                    this.remoteAddressHeaders.addAll(__superior.remoteAddressHeaders);
                }
                if (!__superior.remotePortHeaders.isEmpty()) {
                    this.remotePortHeaders.addAll(__superior.remotePortHeaders);
                }
                return this;
            }

            public Builder remoteAddressHeaders(String __value) {
                this.remoteAddressHeaders.add(__value);
                return this;
            }

            public Builder remoteAddressHeaders(Collection<String> __values) {
                this.remoteAddressHeaders.addAll(__values);
                return this;
            }

            public Builder remotePortHeaders(String __value) {
                this.remotePortHeaders.add(__value);
                return this;
            }

            public Builder remotePortHeaders(Collection<String> __values) {
                this.remotePortHeaders.addAll(__values);
                return this;
            }

            public AccessLog build() {
                return new AccessLog(this);
            }
        }
    }

    public static final class Metric
    extends InnerNode {
        private final LeafNodeVector<String, StringNode> monitoringHandlerPaths;
        private final LeafNodeVector<String, StringNode> searchHandlerPaths;

        public Metric(Builder builder) {
            this(builder, true);
        }

        private Metric(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for server.metric must be initialized: " + builder.__uninitialized);
            }
            this.monitoringHandlerPaths = new LeafNodeVector(builder.monitoringHandlerPaths, (LeafNode)new StringNode());
            this.searchHandlerPaths = new LeafNodeVector(builder.searchHandlerPaths, (LeafNode)new StringNode());
        }

        public List<String> monitoringHandlerPaths() {
            return this.monitoringHandlerPaths.asList();
        }

        public String monitoringHandlerPaths(int i) {
            return ((StringNode)this.monitoringHandlerPaths.get(i)).value();
        }

        public List<String> searchHandlerPaths() {
            return this.searchHandlerPaths.asList();
        }

        public String searchHandlerPaths(int i) {
            return ((StringNode)this.searchHandlerPaths.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Metric newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("metric");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public List<String> monitoringHandlerPaths = new ArrayList<String>();
            public List<String> searchHandlerPaths = new ArrayList<String>();

            public Builder() {
            }

            public Builder(Metric config) {
                this.monitoringHandlerPaths(config.monitoringHandlerPaths());
                this.searchHandlerPaths(config.searchHandlerPaths());
            }

            private Builder override(Builder __superior) {
                if (!__superior.monitoringHandlerPaths.isEmpty()) {
                    this.monitoringHandlerPaths.addAll(__superior.monitoringHandlerPaths);
                }
                if (!__superior.searchHandlerPaths.isEmpty()) {
                    this.searchHandlerPaths.addAll(__superior.searchHandlerPaths);
                }
                return this;
            }

            public Builder monitoringHandlerPaths(String __value) {
                this.monitoringHandlerPaths.add(__value);
                return this;
            }

            public Builder monitoringHandlerPaths(Collection<String> __values) {
                this.monitoringHandlerPaths.addAll(__values);
                return this;
            }

            public Builder searchHandlerPaths(String __value) {
                this.searchHandlerPaths.add(__value);
                return this;
            }

            public Builder searchHandlerPaths(Collection<String> __values) {
                this.searchHandlerPaths.addAll(__values);
                return this;
            }

            public Metric build() {
                return new Metric(this);
            }
        }
    }

    public static final class Jmx
    extends InnerNode {
        private final BooleanNode enabled;
        private final IntegerNode listenPort;

        public Jmx(Builder builder) {
            this(builder, true);
        }

        private Jmx(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for server.jmx must be initialized: " + builder.__uninitialized);
            }
            this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
            this.listenPort = builder.listenPort == null ? new IntegerNode(1099) : new IntegerNode(builder.listenPort.intValue());
        }

        public boolean enabled() {
            return this.enabled.value();
        }

        public int listenPort() {
            return this.listenPort.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Jmx newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("jmx");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean enabled = null;
            private Integer listenPort = null;

            public Builder() {
            }

            public Builder(Jmx config) {
                this.enabled(config.enabled());
                this.listenPort(config.listenPort());
            }

            private Builder override(Builder __superior) {
                if (__superior.enabled != null) {
                    this.enabled(__superior.enabled);
                }
                if (__superior.listenPort != null) {
                    this.listenPort(__superior.listenPort);
                }
                return this;
            }

            public Builder enabled(boolean __value) {
                this.enabled = __value;
                return this;
            }

            private Builder enabled(String __value) {
                return this.enabled(Boolean.valueOf(__value));
            }

            public Builder listenPort(int __value) {
                this.listenPort = __value;
                return this;
            }

            private Builder listenPort(String __value) {
                return this.listenPort(Integer.valueOf(__value));
            }

            public Jmx build() {
                return new Jmx(this);
            }
        }
    }

    public static final class DefaultFilters
    extends InnerNode {
        private final StringNode filterId;
        private final IntegerNode localPort;

        public DefaultFilters(Builder builder) {
            this(builder, true);
        }

        private DefaultFilters(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for server.defaultFilters[] must be initialized: " + builder.__uninitialized);
            }
            this.filterId = builder.filterId == null ? new StringNode() : new StringNode(builder.filterId);
            this.localPort = builder.localPort == null ? new IntegerNode() : new IntegerNode(builder.localPort.intValue());
        }

        public String filterId() {
            return this.filterId.value();
        }

        public int localPort() {
            return this.localPort.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(DefaultFilters newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("defaultFilters");
            return changes;
        }

        private static InnerNodeVector<DefaultFilters> createVector(List<Builder> builders) {
            ArrayList<DefaultFilters> elems = new ArrayList<DefaultFilters>();
            for (Builder b : builders) {
                elems.add(new DefaultFilters(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("filterId", "localPort"));
            private String filterId = null;
            private Integer localPort = null;

            public Builder() {
            }

            public Builder(DefaultFilters config) {
                this.filterId(config.filterId());
                this.localPort(config.localPort());
            }

            private Builder override(Builder __superior) {
                if (__superior.filterId != null) {
                    this.filterId(__superior.filterId);
                }
                if (__superior.localPort != null) {
                    this.localPort(__superior.localPort);
                }
                return this;
            }

            public Builder filterId(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.filterId = __value;
                this.__uninitialized.remove("filterId");
                return this;
            }

            public Builder localPort(int __value) {
                this.localPort = __value;
                this.__uninitialized.remove("localPort");
                return this;
            }

            private Builder localPort(String __value) {
                return this.localPort(Integer.valueOf(__value));
            }

            public DefaultFilters build() {
                return new DefaultFilters(this);
            }
        }
    }

    public static final class Filter
    extends InnerNode {
        private final StringNode id;
        private final StringNode binding;

        public Filter(Builder builder) {
            this(builder, true);
        }

        private Filter(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for server.filter[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new StringNode() : new StringNode(builder.id);
            this.binding = builder.binding == null ? new StringNode() : new StringNode(builder.binding);
        }

        public String id() {
            return this.id.value();
        }

        public String binding() {
            return this.binding.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Filter newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("filter");
            return changes;
        }

        private static InnerNodeVector<Filter> createVector(List<Builder> builders) {
            ArrayList<Filter> elems = new ArrayList<Filter>();
            for (Builder b : builders) {
                elems.add(new Filter(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id", "binding"));
            private String id = null;
            private String binding = null;

            public Builder() {
            }

            public Builder(Filter config) {
                this.id(config.id());
                this.binding(config.binding());
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.binding != null) {
                    this.binding(__superior.binding);
                }
                return this;
            }

            public Builder id(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            public Builder binding(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.binding = __value;
                this.__uninitialized.remove("binding");
                return this;
            }

            public Filter build() {
                return new Filter(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean developerMode = null;
        private Integer responseCompressionLevel = null;
        private Boolean httpKeepAliveEnabled = null;
        private Integer maxKeepAliveRequests = null;
        private Boolean removeRawPostBodyForWwwUrlEncodedPost = null;
        public List<Filter.Builder> filter = new ArrayList<Filter.Builder>();
        public List<DefaultFilters.Builder> defaultFilters = new ArrayList<DefaultFilters.Builder>();
        private Boolean strictFiltering = null;
        private Integer maxWorkerThreads = null;
        private Integer minWorkerThreads = null;
        private Double stopTimeout = null;
        public Jmx.Builder jmx = new Jmx.Builder();
        public Metric.Builder metric = new Metric.Builder();
        public AccessLog.Builder accessLog = new AccessLog.Builder();
        public ConnectionLog.Builder connectionLog = new ConnectionLog.Builder();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ServerConfig config) {
            this.developerMode(config.developerMode());
            this.responseCompressionLevel(config.responseCompressionLevel());
            this.httpKeepAliveEnabled(config.httpKeepAliveEnabled());
            this.maxKeepAliveRequests(config.maxKeepAliveRequests());
            this.removeRawPostBodyForWwwUrlEncodedPost(config.removeRawPostBodyForWwwUrlEncodedPost());
            for (Filter f : config.filter()) {
                this.filter(new Filter.Builder(f));
            }
            for (DefaultFilters d : config.defaultFilters()) {
                this.defaultFilters(new DefaultFilters.Builder(d));
            }
            this.strictFiltering(config.strictFiltering());
            this.maxWorkerThreads(config.maxWorkerThreads());
            this.minWorkerThreads(config.minWorkerThreads());
            this.stopTimeout(config.stopTimeout());
            this.jmx(new Jmx.Builder(config.jmx()));
            this.metric(new Metric.Builder(config.metric()));
            this.accessLog(new AccessLog.Builder(config.accessLog()));
            this.connectionLog(new ConnectionLog.Builder(config.connectionLog()));
        }

        private Builder override(Builder __superior) {
            if (__superior.developerMode != null) {
                this.developerMode(__superior.developerMode);
            }
            if (__superior.responseCompressionLevel != null) {
                this.responseCompressionLevel(__superior.responseCompressionLevel);
            }
            if (__superior.httpKeepAliveEnabled != null) {
                this.httpKeepAliveEnabled(__superior.httpKeepAliveEnabled);
            }
            if (__superior.maxKeepAliveRequests != null) {
                this.maxKeepAliveRequests(__superior.maxKeepAliveRequests);
            }
            if (__superior.removeRawPostBodyForWwwUrlEncodedPost != null) {
                this.removeRawPostBodyForWwwUrlEncodedPost(__superior.removeRawPostBodyForWwwUrlEncodedPost);
            }
            if (!__superior.filter.isEmpty()) {
                this.filter.addAll(__superior.filter);
            }
            if (!__superior.defaultFilters.isEmpty()) {
                this.defaultFilters.addAll(__superior.defaultFilters);
            }
            if (__superior.strictFiltering != null) {
                this.strictFiltering(__superior.strictFiltering);
            }
            if (__superior.maxWorkerThreads != null) {
                this.maxWorkerThreads(__superior.maxWorkerThreads);
            }
            if (__superior.minWorkerThreads != null) {
                this.minWorkerThreads(__superior.minWorkerThreads);
            }
            if (__superior.stopTimeout != null) {
                this.stopTimeout(__superior.stopTimeout);
            }
            this.jmx(this.jmx.override(__superior.jmx));
            this.metric(this.metric.override(__superior.metric));
            this.accessLog(this.accessLog.override(__superior.accessLog));
            this.connectionLog(this.connectionLog.override(__superior.connectionLog));
            return this;
        }

        public Builder developerMode(boolean __value) {
            this.developerMode = __value;
            return this;
        }

        private Builder developerMode(String __value) {
            return this.developerMode(Boolean.valueOf(__value));
        }

        public Builder responseCompressionLevel(int __value) {
            this.responseCompressionLevel = __value;
            return this;
        }

        private Builder responseCompressionLevel(String __value) {
            return this.responseCompressionLevel(Integer.valueOf(__value));
        }

        public Builder httpKeepAliveEnabled(boolean __value) {
            this.httpKeepAliveEnabled = __value;
            return this;
        }

        private Builder httpKeepAliveEnabled(String __value) {
            return this.httpKeepAliveEnabled(Boolean.valueOf(__value));
        }

        public Builder maxKeepAliveRequests(int __value) {
            this.maxKeepAliveRequests = __value;
            return this;
        }

        private Builder maxKeepAliveRequests(String __value) {
            return this.maxKeepAliveRequests(Integer.valueOf(__value));
        }

        public Builder removeRawPostBodyForWwwUrlEncodedPost(boolean __value) {
            this.removeRawPostBodyForWwwUrlEncodedPost = __value;
            return this;
        }

        private Builder removeRawPostBodyForWwwUrlEncodedPost(String __value) {
            return this.removeRawPostBodyForWwwUrlEncodedPost(Boolean.valueOf(__value));
        }

        public Builder filter(Filter.Builder __builder) {
            this.filter.add(__builder);
            return this;
        }

        public Builder filter(Consumer<Filter.Builder> __func) {
            Filter.Builder __inner = new Filter.Builder();
            __func.accept(__inner);
            this.filter.add(__inner);
            return this;
        }

        public Builder filter(List<Filter.Builder> __builders) {
            this.filter = __builders;
            return this;
        }

        public Builder defaultFilters(DefaultFilters.Builder __builder) {
            this.defaultFilters.add(__builder);
            return this;
        }

        public Builder defaultFilters(Consumer<DefaultFilters.Builder> __func) {
            DefaultFilters.Builder __inner = new DefaultFilters.Builder();
            __func.accept(__inner);
            this.defaultFilters.add(__inner);
            return this;
        }

        public Builder defaultFilters(List<DefaultFilters.Builder> __builders) {
            this.defaultFilters = __builders;
            return this;
        }

        public Builder strictFiltering(boolean __value) {
            this.strictFiltering = __value;
            return this;
        }

        private Builder strictFiltering(String __value) {
            return this.strictFiltering(Boolean.valueOf(__value));
        }

        public Builder maxWorkerThreads(int __value) {
            this.maxWorkerThreads = __value;
            return this;
        }

        private Builder maxWorkerThreads(String __value) {
            return this.maxWorkerThreads(Integer.valueOf(__value));
        }

        public Builder minWorkerThreads(int __value) {
            this.minWorkerThreads = __value;
            return this;
        }

        private Builder minWorkerThreads(String __value) {
            return this.minWorkerThreads(Integer.valueOf(__value));
        }

        public Builder stopTimeout(double __value) {
            this.stopTimeout = __value;
            return this;
        }

        private Builder stopTimeout(String __value) {
            return this.stopTimeout(Double.valueOf(__value));
        }

        public Builder jmx(Jmx.Builder __builder) {
            this.jmx = __builder;
            return this;
        }

        public Builder jmx(Consumer<Jmx.Builder> __func) {
            Jmx.Builder __inner = new Jmx.Builder();
            __func.accept(__inner);
            this.jmx = __inner;
            return this;
        }

        public Builder metric(Metric.Builder __builder) {
            this.metric = __builder;
            return this;
        }

        public Builder metric(Consumer<Metric.Builder> __func) {
            Metric.Builder __inner = new Metric.Builder();
            __func.accept(__inner);
            this.metric = __inner;
            return this;
        }

        public Builder accessLog(AccessLog.Builder __builder) {
            this.accessLog = __builder;
            return this;
        }

        public Builder accessLog(Consumer<AccessLog.Builder> __func) {
            AccessLog.Builder __inner = new AccessLog.Builder();
            __func.accept(__inner);
            this.accessLog = __inner;
            return this;
        }

        public Builder connectionLog(ConnectionLog.Builder __builder) {
            this.connectionLog = __builder;
            return this;
        }

        public Builder connectionLog(Consumer<ConnectionLog.Builder> __func) {
            ConnectionLog.Builder __inner = new ConnectionLog.Builder();
            __func.accept(__inner);
            this.connectionLog = __inner;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ServerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ServerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ServerConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ServerConfig build() {
            return new ServerConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

