/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.execution;

import com.yahoo.component.chain.Chain;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.processing.Processor;
import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.Execution;
import com.yahoo.processing.request.ErrorMessage;
import com.yahoo.processing.response.FutureResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AsyncExecution {
    private static final ThreadFactory threadFactory = ThreadFactoryFactory.getThreadFactory((String)"processing");
    private static final Executor executorMain = AsyncExecution.createExecutor();
    private final Execution execution;

    private static final Executor createExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(100, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(false), threadFactory);
        executor.prestartAllCoreThreads();
        return executor;
    }

    public AsyncExecution(Processor processor, Execution parent) {
        this(new Execution(processor, parent));
    }

    public AsyncExecution(Chain<? extends Processor> chain, Execution parent) {
        this(new Execution(chain, parent));
    }

    public AsyncExecution(Execution execution) {
        this.execution = new Execution(execution);
    }

    public FutureResponse process(final Request request) {
        return this.getFutureResponse(new Callable<Response>(){

            @Override
            public Response call() {
                return AsyncExecution.this.execution.process(request);
            }
        }, request);
    }

    private static <T> Future<T> getFuture(Callable<T> callable) {
        FutureTask<T> future = new FutureTask<T>(callable);
        try {
            executorMain.execute(future);
        }
        catch (RejectedExecutionException e) {
            future.run();
        }
        return future;
    }

    private FutureResponse getFutureResponse(Callable<Response> callable, Request request) {
        FutureResponse future = new FutureResponse(callable, this.execution, request);
        try {
            executorMain.execute((Runnable)future.delegate());
        }
        catch (RejectedExecutionException e) {
            future.delegate().run();
        }
        return future;
    }

    public static List<Response> waitForAll(Collection<FutureResponse> tasks, long timeout) {
        final ArrayList<FutureResponse> workingTasks = new ArrayList<FutureResponse>(tasks);
        Future task = AsyncExecution.getFuture(new Callable(){

            public List<Future> call() {
                for (FutureResponse task : workingTasks) {
                    task.get();
                }
                return null;
            }
        });
        try {
            task.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            // empty catch block
        }
        ArrayList<Response> responses = new ArrayList<Response>(tasks.size());
        for (FutureResponse future : workingTasks) {
            responses.add(AsyncExecution.getTaskResponse(future));
        }
        return responses;
    }

    private static Response getTaskResponse(FutureResponse future) {
        if (future.isDone() && !future.isCancelled()) {
            return future.get();
        }
        return new Response(future.getRequest(), new ErrorMessage("Timed out waiting for " + future));
    }
}

