/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.DelegatedRequestHandler;
import com.yahoo.jdisc.handler.NullContent;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseHandler;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

class ReferenceCountingRequestHandler
implements DelegatedRequestHandler {
    private static final Logger log = Logger.getLogger(ReferenceCountingRequestHandler.class.getName());
    final RequestHandler delegate;

    ReferenceCountingRequestHandler(RequestHandler delegate) {
        Objects.requireNonNull(delegate, "delegate");
        this.delegate = delegate;
    }

    public ContentChannel handleRequest(Request request, ResponseHandler responseHandler) {
        try (ResourceReference requestReference = request.refer();){
            ContentChannel contentChannel;
            ReferenceCountingResponseHandler referenceCountingResponseHandler = new ReferenceCountingResponseHandler((SharedResource)request, new NullContentResponseHandler(responseHandler));
            try {
                contentChannel = this.delegate.handleRequest(request, (ResponseHandler)referenceCountingResponseHandler);
                Objects.requireNonNull(contentChannel, "contentChannel");
            }
            catch (Throwable t) {
                try {
                    referenceCountingResponseHandler.unrefer();
                }
                catch (Throwable thrownFromUnrefer) {
                    log.log(Level.WARNING, "Unexpected problem", thrownFromUnrefer);
                }
                throw t;
            }
            ReferenceCountingContentChannel referenceCountingContentChannel = new ReferenceCountingContentChannel((SharedResource)request, contentChannel);
            return referenceCountingContentChannel;
        }
    }

    public void handleTimeout(Request request, ResponseHandler responseHandler) {
        this.delegate.handleTimeout(request, (ResponseHandler)new NullContentResponseHandler(responseHandler));
    }

    public ResourceReference refer() {
        return this.delegate.refer();
    }

    public ResourceReference refer(Object context) {
        return this.delegate.refer(context);
    }

    public void release() {
        this.delegate.release();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public RequestHandler getDelegate() {
        return this.delegate;
    }

    private static class NullContentResponseHandler
    implements ResponseHandler {
        final ResponseHandler delegate;

        NullContentResponseHandler(ResponseHandler delegate) {
            Objects.requireNonNull(delegate, "delegate");
            this.delegate = delegate;
        }

        public ContentChannel handleResponse(Response response) {
            ContentChannel contentChannel = this.delegate.handleResponse(response);
            if (contentChannel == null) {
                contentChannel = NullContent.INSTANCE;
            }
            return contentChannel;
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static class ReferenceCountingCompletionHandler
    implements CompletionHandler {
        final ResourceReference requestReference;
        final CompletionHandler delegate;
        final AtomicBoolean closed = new AtomicBoolean(false);

        public ReferenceCountingCompletionHandler(SharedResource request, CompletionHandler delegate) {
            this.delegate = delegate;
            this.requestReference = request.refer((Object)this);
        }

        public void completed() {
            if (this.closed.getAndSet(true)) {
                throw new AlreadyCompletedException(this.delegate);
            }
            try {
                if (this.delegate != null) {
                    this.delegate.completed();
                }
            }
            finally {
                this.requestReference.close();
            }
        }

        public void failed(Throwable t) {
            if (this.closed.getAndSet(true)) {
                throw new AlreadyCompletedException(this.delegate);
            }
            try (ResourceReference ref = this.requestReference;){
                if (this.delegate != null) {
                    this.delegate.failed(t);
                } else {
                    log.log(Level.WARNING, "Uncaught completion failure.", t);
                }
            }
        }

        public String toString() {
            return String.valueOf(this.delegate);
        }
    }

    private static class AlreadyCompletedException
    extends IllegalStateException {
        public AlreadyCompletedException(CompletionHandler completionHandler) {
            super(completionHandler + " is already called.");
        }
    }

    private static class ReferenceCountingContentChannel
    implements ContentChannel {
        final SharedResource request;
        final ResourceReference requestReference;
        final ContentChannel delegate;

        ReferenceCountingContentChannel(SharedResource request, ContentChannel delegate) {
            Objects.requireNonNull(request, "request");
            Objects.requireNonNull(delegate, "delegate");
            this.request = request;
            this.delegate = delegate;
            this.requestReference = request.refer((Object)this);
        }

        public void write(ByteBuffer buf, CompletionHandler completionHandler) {
            ReferenceCountingCompletionHandler referenceCountingCompletionHandler = new ReferenceCountingCompletionHandler(this.request, completionHandler);
            try {
                this.delegate.write(buf, (CompletionHandler)referenceCountingCompletionHandler);
            }
            catch (Throwable t) {
                try {
                    referenceCountingCompletionHandler.failed(t);
                }
                catch (AlreadyCompletedException alreadyCompletedException) {
                }
                catch (Throwable failFailure) {
                    log.log(Level.WARNING, "Failure during call to CompletionHandler.failed()", failFailure);
                }
                throw t;
            }
        }

        public void close(CompletionHandler completionHandler) {
            ReferenceCountingCompletionHandler referenceCountingCompletionHandler = new ReferenceCountingCompletionHandler(this.request, completionHandler);
            try (ResourceReference ref = this.requestReference;){
                this.delegate.close((CompletionHandler)referenceCountingCompletionHandler);
            }
            catch (Throwable t) {
                try {
                    referenceCountingCompletionHandler.failed(t);
                }
                catch (AlreadyCompletedException alreadyCompletedException) {
                }
                catch (Throwable failFailure) {
                    log.log(Level.WARNING, "Failure during call to CompletionHandler.failed()", failFailure);
                }
                throw t;
            }
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static class ReferenceCountingResponseHandler
    implements ResponseHandler {
        final SharedResource request;
        final ResourceReference requestReference;
        final ResponseHandler delegate;
        final AtomicBoolean closed = new AtomicBoolean(false);

        ReferenceCountingResponseHandler(SharedResource request, ResponseHandler delegate) {
            Objects.requireNonNull(request, "request");
            Objects.requireNonNull(delegate, "delegate");
            this.request = request;
            this.delegate = delegate;
            this.requestReference = request.refer((Object)this);
        }

        public ContentChannel handleResponse(Response response) {
            if (this.closed.getAndSet(true)) {
                throw new IllegalStateException(this.delegate + " is already called.");
            }
            try (ResourceReference ref = this.requestReference;){
                ContentChannel contentChannel = this.delegate.handleResponse(response);
                Objects.requireNonNull(contentChannel, "contentChannel");
                ReferenceCountingContentChannel referenceCountingContentChannel = new ReferenceCountingContentChannel(this.request, contentChannel);
                return referenceCountingContentChannel;
            }
        }

        public String toString() {
            return this.delegate.toString();
        }

        public void unrefer() {
            if (this.closed.getAndSet(true)) {
                return;
            }
            this.requestReference.close();
        }
    }
}

