/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.Cookie;
import com.yahoo.jdisc.http.filter.DiscFilterRequest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.List;

public class FilterUtils {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static boolean isDifferentOrigin(DiscFilterRequest request) {
        try {
            String origin = request.getHeader("Origin");
            if (origin != null && !URI.create(origin).getHost().equals(request.getServerName())) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return false;
    }

    public static void sendRedirectResponse(ResponseHandler handler, List<Cookie> cookies, String location) {
        Response response = FilterUtils.createResponse(302, cookies);
        response.headers().add("Location", location);
        handler.handleResponse(response).close(null);
    }

    public static void sendMessageResponse(ResponseHandler handler, List<Cookie> cookies, int code, String message) {
        Response response = FilterUtils.createResponse(code, cookies);
        ContentChannel contentChannel = handler.handleResponse(response);
        try {
            ObjectNode jsonNode = mapper.createObjectNode();
            jsonNode.set("message", (JsonNode)TextNode.valueOf((String)message));
            byte[] jsonBytes = mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)jsonNode);
            contentChannel.write(ByteBuffer.wrap(jsonBytes), null);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
        contentChannel.close(null);
    }

    private static Response createResponse(int code, List<Cookie> cookies) {
        Response response = new Response(code);
        List<String> setCookieHeaders = Cookie.toSetCookieHeaders(cookies);
        response.headers().add("Set-Cookie", setCookieHeaders);
        return response;
    }

    public static URI createUriFromRequest(DiscFilterRequest request, String path) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getUri().getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

