/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di;

import com.google.inject.Injector;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.container.ComponentsConfig;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.ConfigRetriever;
import com.yahoo.container.di.Osgi;
import com.yahoo.container.di.componentgraph.core.ComponentGraph;
import com.yahoo.container.di.componentgraph.core.ComponentNode;
import com.yahoo.container.di.componentgraph.core.Node;
import com.yahoo.container.di.config.ApplicationBundlesConfig;
import com.yahoo.container.di.config.PlatformBundlesConfig;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.vespa.config.ConfigKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;

public class Container {
    private static final Logger log = Logger.getLogger(Container.class.getName());
    private final SubscriberFactory subscriberFactory;
    private final ConfigKey<ApplicationBundlesConfig> applicationBundlesConfigKey;
    private final ConfigKey<PlatformBundlesConfig> platformBundlesConfigKey;
    private final ConfigKey<ComponentsConfig> componentsConfigKey;
    private final ComponentDeconstructor componentDeconstructor;
    private final Osgi osgi;
    private final ConfigRetriever retriever;
    private List<String> platformBundles;
    private long previousConfigGeneration = -1L;
    private long leastGeneration = -1L;

    public Container(SubscriberFactory subscriberFactory, String configId, ComponentDeconstructor componentDeconstructor, Osgi osgi) {
        this.subscriberFactory = subscriberFactory;
        this.componentDeconstructor = componentDeconstructor;
        this.osgi = osgi;
        this.applicationBundlesConfigKey = new ConfigKey(ApplicationBundlesConfig.class, configId);
        this.platformBundlesConfigKey = new ConfigKey(PlatformBundlesConfig.class, configId);
        this.componentsConfigKey = new ConfigKey(ComponentsConfig.class, configId);
        Set<ConfigKey<? extends ConfigInstance>> bootstrapKeys = Set.of(this.applicationBundlesConfigKey, this.platformBundlesConfigKey, this.componentsConfigKey);
        this.retriever = new ConfigRetriever(bootstrapKeys, subscriberFactory);
    }

    public Container(SubscriberFactory subscriberFactory, String configId, ComponentDeconstructor componentDeconstructor) {
        this(subscriberFactory, configId, componentDeconstructor, new Osgi(){});
    }

    public ComponentGraph getNewComponentGraph(ComponentGraph oldGraph, Injector fallbackInjector, boolean isInitializing) {
        try {
            HashSet<Bundle> obsoleteBundles = new HashSet<Bundle>();
            ComponentGraph newGraph = this.getConfigAndCreateGraph(oldGraph, fallbackInjector, isInitializing, obsoleteBundles);
            newGraph.reuseNodes(oldGraph);
            this.constructComponents(newGraph);
            this.deconstructObsoleteComponents(oldGraph, newGraph, obsoleteBundles);
            return newGraph;
        }
        catch (Throwable t) {
            this.invalidateGeneration(oldGraph.generation(), t);
            throw t;
        }
    }

    private ComponentGraph getConfigAndCreateGraph(ComponentGraph graph, Injector fallbackInjector, boolean isInitializing, Collection<Bundle> obsoleteBundles) {
        ConfigRetriever.ConfigSnapshot snapshot;
        while (true) {
            snapshot = this.retriever.getConfigs(graph.configKeys(), this.leastGeneration, isInitializing);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("getConfigAndCreateGraph:\ngraph.configKeys = %s\ngraph.generation = %s\nsnapshot = %s\n", graph.configKeys(), graph.generation(), snapshot));
            }
            if (snapshot instanceof ConfigRetriever.BootstrapConfigs) {
                if (this.getBootstrapGeneration() <= this.previousConfigGeneration) {
                    throw new IllegalStateException(String.format("Got bootstrap configs out of sequence for old config generation %d.\nPrevious config generation is %d", this.getBootstrapGeneration(), this.previousConfigGeneration));
                }
                log.log(Level.FINE, () -> "Got new bootstrap generation\n" + this.configGenerationsString());
                if (graph.generation() == 0L) {
                    this.platformBundles = Container.getConfig(this.platformBundlesConfigKey, snapshot.configs()).bundlePaths();
                    this.osgi.installPlatformBundles(this.platformBundles);
                } else {
                    this.throwIfPlatformBundlesChanged(snapshot);
                }
                Set<Bundle> bundlesToRemove = this.installApplicationBundles(snapshot.configs());
                obsoleteBundles.addAll(bundlesToRemove);
                graph = this.createComponentsGraph(snapshot.configs(), this.getBootstrapGeneration(), fallbackInjector);
                continue;
            }
            if (snapshot instanceof ConfigRetriever.ComponentsConfigs) break;
        }
        log.log(Level.FINE, () -> "Got components configs,\n" + this.configGenerationsString());
        return this.createAndConfigureComponentsGraph(snapshot.configs(), fallbackInjector);
    }

    private long getBootstrapGeneration() {
        return this.retriever.getBootstrapGeneration();
    }

    private long getComponentsGeneration() {
        return this.retriever.getComponentsGeneration();
    }

    private String configGenerationsString() {
        return String.format("bootstrap generation = %d\ncomponents generation: %d\nprevious generation: %d", this.getBootstrapGeneration(), this.getComponentsGeneration(), this.previousConfigGeneration);
    }

    private void throwIfPlatformBundlesChanged(ConfigRetriever.ConfigSnapshot snapshot) {
        List<String> checkPlatformBundles = Container.getConfig(this.platformBundlesConfigKey, snapshot.configs()).bundlePaths();
        if (!checkPlatformBundles.equals(this.platformBundles)) {
            throw new RuntimeException("Platform bundles are not allowed to change!\nOld: " + this.platformBundles + "\nNew: " + checkPlatformBundles);
        }
    }

    private ComponentGraph createAndConfigureComponentsGraph(Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> componentsConfigs, Injector fallbackInjector) {
        ComponentGraph componentGraph = this.createComponentsGraph(componentsConfigs, this.getComponentsGeneration(), fallbackInjector);
        componentGraph.setAvailableConfigs(componentsConfigs);
        return componentGraph;
    }

    private void constructComponents(ComponentGraph graph) {
        graph.nodes().forEach(Node::constructInstance);
    }

    private void deconstructObsoleteComponents(ComponentGraph oldGraph, ComponentGraph newGraph, Collection<Bundle> obsoleteBundles) {
        IdentityHashMap newComponents = new IdentityHashMap(newGraph.size());
        for (Object component : newGraph.allConstructedComponentsAndProviders()) {
            newComponents.put(component, null);
        }
        ArrayList<Object> obsoleteComponents = new ArrayList<Object>();
        for (Object component : oldGraph.allConstructedComponentsAndProviders()) {
            if (newComponents.containsKey(component)) continue;
            obsoleteComponents.add(component);
        }
        this.componentDeconstructor.deconstruct(obsoleteComponents, obsoleteBundles);
    }

    private Set<Bundle> installApplicationBundles(Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> configsIncludingBootstrapConfigs) {
        ApplicationBundlesConfig applicationBundlesConfig = Container.getConfig(this.applicationBundlesConfigKey, configsIncludingBootstrapConfigs);
        return this.osgi.useApplicationBundles(applicationBundlesConfig.bundles());
    }

    private ComponentGraph createComponentsGraph(Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> configsIncludingBootstrapConfigs, long generation, Injector fallbackInjector) {
        this.previousConfigGeneration = generation;
        ComponentGraph graph = new ComponentGraph(generation);
        ComponentsConfig componentsConfig = Container.getConfig(this.componentsConfigKey, configsIncludingBootstrapConfigs);
        if (componentsConfig == null) {
            throw new ConfigurationRuntimeException("The set of all configs does not include a valid 'components' config. Config set: " + configsIncludingBootstrapConfigs.keySet());
        }
        this.addNodes(componentsConfig, graph);
        this.injectNodes(componentsConfig, graph);
        graph.complete(fallbackInjector);
        return graph;
    }

    private void addNodes(ComponentsConfig componentsConfig, ComponentGraph graph) {
        for (ComponentsConfig.Components config : componentsConfig.components()) {
            BundleInstantiationSpecification specification = Container.bundleInstantiationSpecification(config);
            Class<?> componentClass = this.osgi.resolveClass(specification);
            ComponentNode componentNode = new ComponentNode(specification.id, config.configId(), componentClass, null);
            graph.add(componentNode);
        }
    }

    private void injectNodes(ComponentsConfig config, ComponentGraph graph) {
        for (ComponentsConfig.Components component : config.components()) {
            Node componentNode = ComponentGraph.getNode(graph, component.id());
            for (ComponentsConfig.Components.Inject inject : component.inject()) {
                componentNode.inject(ComponentGraph.getNode(graph, inject.id()));
            }
        }
    }

    private void invalidateGeneration(long generation, Throwable cause) {
        this.leastGeneration = Math.max(this.retriever.getComponentsGeneration(), this.retriever.getBootstrapGeneration()) + 1L;
        if (!(cause instanceof InterruptedException) && !(cause instanceof ConfigInterruptedException)) {
            log.log(Level.WARNING, Container.newGraphErrorMessage(generation, cause), cause);
        }
    }

    private static String newGraphErrorMessage(long generation, Throwable cause) {
        String failedFirstMessage = "Failed to set up first component graph";
        String failedNewMessage = "Failed to set up new component graph";
        String constructMessage = " due to error when constructing one of the components";
        String retainMessage = ". Retaining previous component generation.";
        if (generation == 0L) {
            if (cause instanceof ComponentNode.ComponentConstructorException) {
                return failedFirstMessage + constructMessage;
            }
            return failedFirstMessage;
        }
        if (cause instanceof ComponentNode.ComponentConstructorException) {
            return failedNewMessage + constructMessage + retainMessage;
        }
        return failedNewMessage + retainMessage;
    }

    public void shutdown(ComponentGraph graph, ComponentDeconstructor deconstructor) {
        this.shutdownConfigurer();
        if (graph != null) {
            this.deconstructAllComponents(graph, deconstructor);
        }
    }

    void shutdownConfigurer() {
        this.retriever.shutdown();
    }

    public void reloadConfig(long generation) {
        this.subscriberFactory.reloadActiveSubscribers(generation);
    }

    private void deconstructAllComponents(ComponentGraph graph, ComponentDeconstructor deconstructor) {
        deconstructor.deconstruct(graph.allConstructedComponentsAndProviders(), Collections.emptyList());
    }

    public static <T extends ConfigInstance> T getConfig(ConfigKey<T> key, Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> configs) {
        ConfigInstance inst = configs.get(key);
        if (inst == null || key.getConfigClass() == null) {
            throw new RuntimeException("Missing config " + key);
        }
        return (T)((ConfigInstance)key.getConfigClass().cast(inst));
    }

    private static BundleInstantiationSpecification bundleInstantiationSpecification(ComponentsConfig.Components config) {
        return BundleInstantiationSpecification.getFromStrings(config.id(), config.classId(), config.bundle());
    }
}

