/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.http.server.jetty.Janitor;
import com.yahoo.jdisc.http.server.jetty.RequestMetricReporter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

class ServletRequestReader {
    private static final Logger log = Logger.getLogger(ServletRequestReader.class.getName());
    private static final int BUFFER_SIZE_BYTES = 8192;
    private final Object monitor = new Object();
    private final ServletInputStream in;
    private final ContentChannel requestContentChannel;
    private final Janitor janitor;
    private final RequestMetricReporter metricReporter;
    private Throwable errorDuringRead;
    private int bytesRead;
    private State state = State.READING;
    private int numberOfOutstandingUserCalls = 0;
    private final CompletableFuture<Void> finishedFuture = new CompletableFuture();

    ServletRequestReader(ServletInputStream in, ContentChannel requestContentChannel, Janitor janitor, RequestMetricReporter metricReporter) {
        this.in = Objects.requireNonNull(in);
        this.requestContentChannel = Objects.requireNonNull(requestContentChannel);
        this.janitor = Objects.requireNonNull(janitor);
        this.metricReporter = Objects.requireNonNull(metricReporter);
        in.setReadListener((ReadListener)new Listener());
    }

    CompletableFuture<Void> finishedFuture() {
        return this.finishedFuture;
    }

    void fail(Throwable t) {
        this.doneReading(t);
        this.finishedFuture.completeExceptionally(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseOutstandingUserCallsAndCloseRequestContentChannelConditionally() {
        boolean shouldCloseRequestContentChannel;
        Object object = this.monitor;
        synchronized (object) {
            this.assertStateNotEquals(this.state, State.REQUEST_CONTENT_CLOSED);
            --this.numberOfOutstandingUserCalls;
            boolean bl = shouldCloseRequestContentChannel = this.numberOfOutstandingUserCalls == 0 && this.state == State.ALL_DATA_READ;
            if (shouldCloseRequestContentChannel) {
                this.state = State.REQUEST_CONTENT_CLOSED;
            }
        }
        if (shouldCloseRequestContentChannel) {
            this.janitor.scheduleTask(this::closeRequestContentChannel);
        }
    }

    private void assertStateNotEquals(State state, State notExpectedState) {
        if (state == notExpectedState) {
            AssertionError e = new AssertionError((Object)("State should not be " + notExpectedState));
            log.log(Level.WARNING, "Assertion failed. numberOfOutstandingUserCalls = " + this.numberOfOutstandingUserCalls + ", isDone = " + this.finishedFuture.isDone(), (Throwable)((Object)e));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneReading(Throwable t) {
        int bytesRead;
        boolean shouldCloseRequestContentChannel;
        Object object = this.monitor;
        synchronized (object) {
            this.errorDuringRead = t;
            if (this.state != State.READING) {
                return;
            }
            this.state = State.ALL_DATA_READ;
            boolean bl = shouldCloseRequestContentChannel = this.numberOfOutstandingUserCalls == 0;
            if (shouldCloseRequestContentChannel) {
                this.state = State.REQUEST_CONTENT_CLOSED;
            }
            bytesRead = this.bytesRead;
        }
        if (shouldCloseRequestContentChannel) {
            this.closeRequestContentChannel();
        }
        this.metricReporter.contentSize(bytesRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRequestContentChannel() {
        Throwable readError;
        Object object = this.monitor;
        synchronized (object) {
            readError = this.errorDuringRead;
        }
        try {
            if (readError != null) {
                this.requestContentChannel.onError(readError);
            }
            final CompletableFuture completedCalledFuture = new CompletableFuture();
            this.requestContentChannel.close(new CompletionHandler(){

                public void completed() {
                    completedCalledFuture.complete(null);
                }

                public void failed(Throwable t) {
                    ServletRequestReader.this.finishedFuture.completeExceptionally(t);
                }
            });
            completedCalledFuture.whenComplete((__, ___) -> this.finishedFuture.complete(null));
        }
        catch (Throwable t) {
            this.finishedFuture.completeExceptionally(t);
        }
    }

    private class Listener
    implements ReadListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDataAvailable() throws IOException {
            while (ServletRequestReader.this.in.isReady()) {
                int numBytesRead;
                byte[] buffer = new byte[8192];
                Object object = ServletRequestReader.this.monitor;
                synchronized (object) {
                    numBytesRead = ServletRequestReader.this.in.read(buffer);
                    if (numBytesRead < 0) {
                        return;
                    }
                    if (ServletRequestReader.this.state != State.READING) {
                        assert (ServletRequestReader.this.finishedFuture.isCompletedExceptionally());
                        return;
                    }
                    ServletRequestReader.this.numberOfOutstandingUserCalls += 2;
                    ServletRequestReader.this.bytesRead += numBytesRead;
                }
                try {
                    ServletRequestReader.this.requestContentChannel.write(ByteBuffer.wrap(buffer, 0, numBytesRead), new CompletionHandler(){

                        public void completed() {
                            ServletRequestReader.this.decreaseOutstandingUserCallsAndCloseRequestContentChannelConditionally();
                        }

                        public void failed(Throwable t) {
                            ServletRequestReader.this.decreaseOutstandingUserCallsAndCloseRequestContentChannelConditionally();
                            ServletRequestReader.this.finishedFuture.completeExceptionally(t);
                        }
                    });
                    ServletRequestReader.this.metricReporter.successfulRead(numBytesRead);
                }
                catch (Throwable t) {
                    ServletRequestReader.this.finishedFuture.completeExceptionally(t);
                }
                finally {
                    ServletRequestReader.this.decreaseOutstandingUserCallsAndCloseRequestContentChannelConditionally();
                }
            }
        }

        public void onError(Throwable t) {
            ServletRequestReader.this.fail(t);
        }

        public void onAllDataRead() {
            ServletRequestReader.this.doneReading(null);
        }
    }

    private static enum State {
        READING,
        ALL_DATA_READ,
        REQUEST_CONTENT_CLOSED;

    }
}

