/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di;

import com.google.common.collect.Sets;
import com.yahoo.config.ConfigInstance;
import com.yahoo.container.di.componentgraph.core.Keys;
import com.yahoo.container.di.config.Subscriber;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.vespa.config.ConfigKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConfigRetriever {
    private static final Logger log = Logger.getLogger(ConfigRetriever.class.getName());
    private final Set<ConfigKey<? extends ConfigInstance>> bootstrapKeys;
    private Set<ConfigKey<? extends ConfigInstance>> componentSubscriberKeys;
    private final SubscriberFactory subscriberFactory;
    private final Subscriber bootstrapSubscriber;
    private Subscriber componentSubscriber;
    private int componentSubscriberIndex;

    public ConfigRetriever(Set<ConfigKey<? extends ConfigInstance>> bootstrapKeys, SubscriberFactory subscriberFactory) {
        this.bootstrapKeys = bootstrapKeys;
        this.componentSubscriberKeys = new HashSet<ConfigKey<? extends ConfigInstance>>();
        this.subscriberFactory = subscriberFactory;
        if (bootstrapKeys.isEmpty()) {
            throw new IllegalArgumentException("Bootstrap key set is empty");
        }
        this.bootstrapSubscriber = this.subscriberFactory.getSubscriber(bootstrapKeys, "bootstrap");
        this.componentSubscriber = this.subscriberFactory.getSubscriber(this.componentSubscriberKeys, "component_" + ++this.componentSubscriberIndex);
    }

    public ConfigSnapshot getConfigs(Set<ConfigKey<? extends ConfigInstance>> componentConfigKeys, long leastGeneration, boolean isInitializing) {
        Optional<ConfigSnapshot> maybeSnapshot;
        while (!(maybeSnapshot = this.getConfigsOnce(componentConfigKeys, leastGeneration, isInitializing)).isPresent()) {
        }
        ConfigSnapshot configSnapshot = maybeSnapshot.get();
        this.resetComponentSubscriberIfBootstrap(configSnapshot);
        return configSnapshot;
    }

    private Optional<ConfigSnapshot> getConfigsOnce(Set<ConfigKey<? extends ConfigInstance>> componentConfigKeys, long leastGeneration, boolean isInitializing) {
        if (!Sets.intersection(componentConfigKeys, this.bootstrapKeys).isEmpty()) {
            throw new IllegalArgumentException("Component config keys [" + componentConfigKeys + "] overlaps with bootstrap config keys [" + this.bootstrapKeys + "]");
        }
        HashSet<ConfigKey<? extends ConfigInstance>> allKeys = new HashSet<ConfigKey<? extends ConfigInstance>>(componentConfigKeys);
        allKeys.addAll(this.bootstrapKeys);
        this.setupComponentSubscriber(allKeys);
        Optional<ConfigSnapshot> maybeSnapshot = this.getConfigsOptional(leastGeneration, isInitializing);
        log.log(Level.FINE, () -> "getConfigsOnce returning " + maybeSnapshot);
        return maybeSnapshot;
    }

    private Optional<ConfigSnapshot> getConfigsOptional(long leastGeneration, boolean isInitializing) {
        if (this.componentSubscriber.generation() < this.bootstrapSubscriber.generation()) {
            return this.getComponentsSnapshot(leastGeneration, isInitializing);
        }
        long newestBootstrapGeneration = this.bootstrapSubscriber.waitNextGeneration(isInitializing);
        log.log(Level.FINE, () -> "getConfigsOptional: new bootstrap generation: " + newestBootstrapGeneration);
        if (newestBootstrapGeneration < leastGeneration) {
            return Optional.empty();
        }
        return this.bootstrapConfigIfChanged();
    }

    private Optional<ConfigSnapshot> getComponentsSnapshot(long leastGeneration, boolean isInitializing) {
        long newestBootstrapGeneration = this.bootstrapSubscriber.generation();
        long newestComponentGeneration = this.componentSubscriber.waitNextGeneration(isInitializing);
        if (newestComponentGeneration < leastGeneration) {
            log.log(Level.FINE, () -> "Component generation too old: " + this.componentSubscriber.generation() + " < " + leastGeneration);
            return Optional.empty();
        }
        if (newestComponentGeneration == newestBootstrapGeneration) {
            log.log(Level.FINE, () -> "getConfigsOptional: new component generation: " + this.componentSubscriber.generation());
            return this.componentsConfigIfChanged();
        }
        log.warning("Did not get same generation for bootstrap (" + newestBootstrapGeneration + ") and components configs (" + newestComponentGeneration + ").");
        return Optional.empty();
    }

    private Optional<ConfigSnapshot> bootstrapConfigIfChanged() {
        return this.configIfChanged(this.bootstrapSubscriber, BootstrapConfigs::new);
    }

    private Optional<ConfigSnapshot> componentsConfigIfChanged() {
        return this.configIfChanged(this.componentSubscriber, ComponentsConfigs::new);
    }

    private Optional<ConfigSnapshot> configIfChanged(Subscriber subscriber, Function<Map<ConfigKey<? extends ConfigInstance>, ConfigInstance>, ConfigSnapshot> constructor) {
        if (subscriber.configChanged()) {
            return Optional.of(constructor.apply(Keys.covariantCopy(subscriber.config())));
        }
        return Optional.empty();
    }

    private void resetComponentSubscriberIfBootstrap(ConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof BootstrapConfigs) {
            this.setupComponentSubscriber(Collections.emptySet());
        }
    }

    private void setupComponentSubscriber(Set<ConfigKey<? extends ConfigInstance>> keys) {
        if (!this.componentSubscriberKeys.equals(keys)) {
            this.componentSubscriber.close();
            log.log(Level.FINE, () -> "Closed " + this.componentSubscriber);
            this.componentSubscriberKeys = keys;
            try {
                this.componentSubscriber = this.subscriberFactory.getSubscriber(keys, "component_" + ++this.componentSubscriberIndex);
                log.log(Level.FINE, () -> "Set up new subscriber " + this.componentSubscriber + " for keys: " + keys);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Failed setting up subscriptions for component configs: " + e.getMessage());
                log.log(Level.WARNING, "Config keys: " + keys);
                throw e;
            }
        }
    }

    public void shutdown() {
        this.bootstrapSubscriber.close();
        this.componentSubscriber.close();
    }

    public long getBootstrapGeneration() {
        return this.bootstrapSubscriber.generation();
    }

    public long getComponentsGeneration() {
        return this.componentSubscriber.generation();
    }

    public static class ComponentsConfigs
    extends ConfigSnapshot {
        ComponentsConfigs(Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> configs) {
            super(configs);
        }
    }

    public static class BootstrapConfigs
    extends ConfigSnapshot {
        BootstrapConfigs(Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> configs) {
            super(configs);
        }
    }

    public static class ConfigSnapshot {
        private final Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> configs;

        ConfigSnapshot(Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> configs) {
            this.configs = configs;
        }

        public Map<ConfigKey<? extends ConfigInstance>, ConfigInstance> configs() {
            return this.configs;
        }

        public int size() {
            return this.configs.size();
        }
    }
}

