/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.ssl.impl;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.ssl.SslContextFactoryProvider;
import com.yahoo.jdisc.http.ssl.impl.TlsContextBasedProvider;
import com.yahoo.security.tls.ConfigFileBasedTlsContext;
import com.yahoo.security.tls.PeerAuthentication;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.nio.file.Path;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class DefaultSslContextFactoryProvider
extends AbstractComponent
implements SslContextFactoryProvider {
    private final SslContextFactoryProvider instance = TransportSecurityUtils.getConfigFile().map(configFile -> DefaultSslContextFactoryProvider.createTlsContextBasedProvider(connectorConfig, configFile)).orElseGet(() -> new ThrowingSslContextFactoryProvider());

    @Inject
    public DefaultSslContextFactoryProvider(ConnectorConfig connectorConfig) {
    }

    private static SslContextFactoryProvider createTlsContextBasedProvider(ConnectorConfig connectorConfig, Path configFile) {
        return new StaticTlsContextBasedProvider((TlsContext)new ConfigFileBasedTlsContext(configFile, TransportSecurityUtils.getInsecureAuthorizationMode(), DefaultSslContextFactoryProvider.getPeerAuthenticationMode(connectorConfig)));
    }

    private static PeerAuthentication getPeerAuthenticationMode(ConnectorConfig connectorConfig) {
        return connectorConfig.tlsClientAuthEnforcer().enable() ? PeerAuthentication.WANT : PeerAuthentication.NEED;
    }

    @Override
    public SslContextFactory getInstance(String containerId, int port) {
        return this.instance.getInstance(containerId, port);
    }

    public void deconstruct() {
        this.instance.close();
    }

    private static class StaticTlsContextBasedProvider
    extends TlsContextBasedProvider {
        final TlsContext tlsContext;

        StaticTlsContextBasedProvider(TlsContext tlsContext) {
            this.tlsContext = tlsContext;
        }

        @Override
        protected TlsContext getTlsContext(String containerId, int port) {
            return this.tlsContext;
        }

        public void deconstruct() {
            this.tlsContext.close();
        }
    }

    private static class ThrowingSslContextFactoryProvider
    implements SslContextFactoryProvider {
        private ThrowingSslContextFactoryProvider() {
        }

        @Override
        public SslContextFactory getInstance(String containerId, int port) {
            throw new UnsupportedOperationException();
        }
    }
}

