/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigHandle;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.container.di.config.Subscriber;
import com.yahoo.vespa.config.ConfigKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CloudSubscriber
implements Subscriber {
    private static final Logger log = Logger.getLogger(CloudSubscriber.class.getName());
    private final String name;
    private final ConfigSubscriber subscriber;
    private final Map<ConfigKey<ConfigInstance>, ConfigHandle<ConfigInstance>> handles = new HashMap<ConfigKey<ConfigInstance>, ConfigHandle<ConfigInstance>>();
    private long generation = -1L;

    CloudSubscriber(String name, ConfigSource configSource, Set<ConfigKey<ConfigInstance>> keys) {
        this.name = name;
        this.subscriber = new ConfigSubscriber(configSource);
        keys.forEach(k -> this.handles.put((ConfigKey<ConfigInstance>)k, (ConfigHandle<ConfigInstance>)this.subscriber.subscribe(k.getConfigClass(), k.getConfigId())));
    }

    @Override
    public boolean configChanged() {
        return this.handles.values().stream().anyMatch(ConfigHandle::isChanged);
    }

    @Override
    public long generation() {
        return this.generation;
    }

    @Override
    public Map<ConfigKey<ConfigInstance>, ConfigInstance> config() {
        HashMap<ConfigKey<ConfigInstance>, ConfigInstance> ret = new HashMap<ConfigKey<ConfigInstance>, ConfigInstance>();
        this.handles.forEach((k, v) -> ret.put((ConfigKey<ConfigInstance>)k, v.getConfig()));
        return ret;
    }

    @Override
    public long waitNextGeneration(boolean isInitializing) {
        if (this.handles.isEmpty()) {
            throw new IllegalStateException("No config keys registered");
        }
        boolean gotNextGen = false;
        while (!gotNextGen) {
            try {
                if (!this.subscriber.nextGeneration(isInitializing)) continue;
                gotNextGen = true;
                log.log(Level.FINE, () -> this + " got next config generation " + this.subscriber.getGeneration() + "\n" + this.subscriber.toString());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed retrieving the next config generation", e);
            }
        }
        this.generation = this.subscriber.getGeneration();
        return this.generation;
    }

    @Override
    public void close() {
        this.subscriber.close();
    }

    public String toString() {
        return "CloudSubscriber{" + this.name + ", gen." + this.generation + "}";
    }

    ConfigSubscriber getSubscriber() {
        return this.subscriber;
    }
}

