/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.container.logging.Coverage;
import com.yahoo.container.logging.FormatUtil;
import com.yahoo.container.logging.HitCounts;
import com.yahoo.container.logging.LogWriter;
import com.yahoo.container.logging.RequestLogEntry;
import com.yahoo.container.logging.TraceRenderer;
import com.yahoo.yolean.trace.TraceNode;
import com.yahoo.yolean.trace.TraceVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Collection;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSONFormatter
implements LogWriter<RequestLogEntry> {
    private static final String COVERAGE = "coverage";
    private static final String COVERAGE_COVERAGE = "coverage";
    private static final String COVERAGE_DOCUMENTS = "documents";
    private static final String COVERAGE_DEGRADE = "degraded";
    private static final String COVERAGE_DEGRADE_MATCHPHASE = "match-phase";
    private static final String COVERAGE_DEGRADE_TIMEOUT = "timeout";
    private static final String COVERAGE_DEGRADE_ADAPTIVE_TIMEOUT = "adaptive-timeout";
    private static final String COVERAGE_DEGRADED_NON_IDEAL_STATE = "non-ideal-state";
    private final JsonFactory generatorFactory = new JsonFactory((ObjectCodec)new ObjectMapper());
    private static Logger logger = Logger.getLogger(JSONFormatter.class.getName());

    @Override
    public void write(RequestLogEntry entry, OutputStream outputStream) throws IOException {
        try (JsonGenerator generator = this.createJsonGenerator(outputStream);){
            Collection<String> keys;
            TraceNode trace;
            Principal sslPrincipal;
            Principal userPrincipal;
            generator.writeStartObject();
            String peerAddress = entry.peerAddress().get();
            generator.writeStringField("ip", peerAddress);
            long time = entry.timestamp().get().toEpochMilli();
            FormatUtil.writeSecondsField(generator, "time", time);
            FormatUtil.writeSecondsField(generator, "duration", entry.duration().get());
            generator.writeNumberField("responsesize", entry.responseSize().orElse(0L));
            generator.writeNumberField("requestsize", entry.requestSize().orElse(0L));
            generator.writeNumberField("code", entry.statusCode().orElse(0));
            generator.writeStringField("method", entry.httpMethod().orElse(""));
            generator.writeStringField("uri", JSONFormatter.getNormalizedURI(entry.rawPath().orElse(null), entry.rawQuery().orElse(null)));
            generator.writeStringField("version", entry.httpVersion().orElse(""));
            generator.writeStringField("agent", entry.userAgent().orElse(""));
            generator.writeStringField("host", entry.hostString().orElse(""));
            generator.writeStringField("scheme", (String)entry.scheme().orElse(null));
            generator.writeNumberField("localport", entry.localPort().getAsInt());
            String connectionId = entry.connectionId().orElse(null);
            if (connectionId != null) {
                generator.writeStringField("connection", connectionId);
            }
            if ((userPrincipal = (Principal)entry.userPrincipal().orElse(null)) != null) {
                generator.writeStringField("user-principal", userPrincipal.getName());
            }
            if ((sslPrincipal = (Principal)entry.sslPrincipal().orElse(null)) != null) {
                generator.writeStringField("ssl-principal", sslPrincipal.getName());
            }
            String remoteAddress = entry.remoteAddress().orElse(null);
            int remotePort = entry.remotePort().orElse(0);
            if (this.remoteAddressDiffers(peerAddress, remoteAddress)) {
                generator.writeStringField("remoteaddr", remoteAddress);
                if (remotePort > 0) {
                    generator.writeNumberField("remoteport", remotePort);
                }
            }
            if (peerAddress != null) {
                generator.writeStringField("peeraddr", peerAddress);
                int peerPort = entry.peerPort().getAsInt();
                if (peerPort > 0 && peerPort != remotePort) {
                    generator.writeNumberField("peerport", peerPort);
                }
            }
            if ((trace = (TraceNode)entry.traceNode().orElse(null)) != null) {
                long timestamp = trace.timestamp();
                if (timestamp == 0L) {
                    timestamp = time;
                }
                trace.accept((TraceVisitor)new TraceRenderer(generator, timestamp));
            }
            if (this.isSearchRequest(entry)) {
                HitCounts hitCounts = entry.hitCounts().get();
                generator.writeObjectFieldStart("search");
                generator.writeNumberField("totalhits", this.getTotalHitCount(hitCounts));
                generator.writeNumberField("hits", this.getRetrievedHitCount(hitCounts));
                Coverage c = hitCounts.getCoverage();
                if (c != null) {
                    generator.writeObjectFieldStart("coverage");
                    generator.writeNumberField("coverage", c.getResultPercentage());
                    generator.writeNumberField(COVERAGE_DOCUMENTS, c.getDocs());
                    if (c.isDegraded()) {
                        generator.writeObjectFieldStart(COVERAGE_DEGRADE);
                        if (c.isDegradedByMatchPhase()) {
                            generator.writeBooleanField(COVERAGE_DEGRADE_MATCHPHASE, c.isDegradedByMatchPhase());
                        }
                        if (c.isDegradedByTimeout()) {
                            generator.writeBooleanField(COVERAGE_DEGRADE_TIMEOUT, c.isDegradedByTimeout());
                        }
                        if (c.isDegradedByAdapativeTimeout()) {
                            generator.writeBooleanField(COVERAGE_DEGRADE_ADAPTIVE_TIMEOUT, c.isDegradedByAdapativeTimeout());
                        }
                        if (c.isDegradedByNonIdealState()) {
                            generator.writeBooleanField(COVERAGE_DEGRADED_NON_IDEAL_STATE, c.isDegradedByNonIdealState());
                        }
                        generator.writeEndObject();
                    }
                    generator.writeEndObject();
                }
                generator.writeEndObject();
            }
            if (!(keys = entry.extraAttributeKeys()).isEmpty()) {
                generator.writeObjectFieldStart("attributes");
                for (String key : keys) {
                    Collection<String> values = entry.extraAttributeValues(key);
                    if (values.size() == 1) {
                        generator.writeStringField(key, values.iterator().next());
                        continue;
                    }
                    generator.writeFieldName(key);
                    generator.writeStartArray();
                    for (String s : values) {
                        generator.writeString(s);
                    }
                    generator.writeEndArray();
                }
                generator.writeEndObject();
            }
            generator.writeEndObject();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to generate JSON access log entry: " + e.getMessage(), e);
        }
    }

    private JsonGenerator createJsonGenerator(OutputStream outputStream) throws IOException {
        return this.generatorFactory.createGenerator(outputStream, JsonEncoding.UTF8).configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false).configure(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM, false);
    }

    private boolean remoteAddressDiffers(String ipV4Address, String remoteAddress) {
        return remoteAddress != null && !Objects.equals(ipV4Address, remoteAddress);
    }

    private boolean isSearchRequest(RequestLogEntry entry) {
        return entry != null && entry.hitCounts().isPresent();
    }

    private long getTotalHitCount(HitCounts counts) {
        if (counts == null) {
            return 0L;
        }
        return counts.getTotalHitCount();
    }

    private int getRetrievedHitCount(HitCounts counts) {
        if (counts == null) {
            return 0;
        }
        return counts.getRetrievedHitCount();
    }

    private static String getNormalizedURI(String rawPath, String rawQuery) {
        if (rawPath == null) {
            return null;
        }
        return rawQuery != null ? rawPath + "?" + rawQuery : rawPath;
    }
}

