/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.yahoo.concurrent.ThreadLocalDirectory;
import com.yahoo.metrics.simple.Bucket;
import com.yahoo.metrics.simple.Counter;
import com.yahoo.metrics.simple.Gauge;
import com.yahoo.metrics.simple.MetricSettings;
import com.yahoo.metrics.simple.MetricUpdater;
import com.yahoo.metrics.simple.Point;
import com.yahoo.metrics.simple.PointBuilder;
import com.yahoo.metrics.simple.Sample;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

@Beta
public class MetricReceiver {
    public static final MetricReceiver nullImplementation = new NullReceiver();
    private final ThreadLocalDirectory<Bucket, Sample> metricsCollection;
    private final AtomicReference<Bucket> currentSnapshot;
    private final Object histogramDefinitionsLock = new Object();
    private volatile Map<String, MetricSettings> metricSettings;

    public MetricReceiver(ThreadLocalDirectory<Bucket, Sample> metricsCollection, AtomicReference<Bucket> currentSnapshot) {
        this.metricsCollection = metricsCollection;
        this.currentSnapshot = currentSnapshot;
        this.metricSettings = new ImmutableMap.Builder().build();
    }

    public void update(Sample sample) {
        sample.setReceiver(this);
        this.metricsCollection.update((Object)sample);
    }

    public Counter declareCounter(String name) {
        return this.declareCounter(name, null);
    }

    public Counter declareCounter(String name, Point boundDimensions) {
        return new Counter(name, boundDimensions, this);
    }

    public Gauge declareGauge(String name) {
        return this.declareGauge(name, null);
    }

    public Gauge declareGauge(String name, Point boundDimensions) {
        return this.declareGauge(name, Optional.ofNullable(boundDimensions), null);
    }

    public Gauge declareGauge(String name, Optional<Point> boundDimensions, MetricSettings customSettings) {
        if (customSettings != null) {
            this.addMetricDefinition(name, customSettings);
        }
        Point defaultDimensions = null;
        if (boundDimensions.isPresent()) {
            defaultDimensions = boundDimensions.get();
        }
        return new Gauge(name, defaultDimensions, this);
    }

    public PointBuilder pointBuilder() {
        return new PointBuilder();
    }

    public Bucket getSnapshot() {
        return this.currentSnapshot.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMetricDefinition(String metricName, MetricSettings definition) {
        Object object = this.histogramDefinitionsLock;
        synchronized (object) {
            Map<String, MetricSettings> oldMetricDefinitions = this.metricSettings;
            HashMap<String, MetricSettings> builderMap = new HashMap<String, MetricSettings>(oldMetricDefinitions.size() + 1);
            builderMap.putAll(oldMetricDefinitions);
            builderMap.put(metricName, definition);
            this.metricSettings = ImmutableMap.copyOf(builderMap);
        }
    }

    MetricSettings getMetricDefinition(String metricName) {
        return this.metricSettings.get(metricName);
    }

    private static final class NullReceiver
    extends MetricReceiver {
        NullReceiver() {
            super(null, null);
        }

        @Override
        public void update(Sample s) {
        }

        @Override
        public Counter declareCounter(String name) {
            return new NullCounter();
        }

        @Override
        public Counter declareCounter(String name, Point boundDimensions) {
            return new NullCounter();
        }

        @Override
        public Gauge declareGauge(String name) {
            return new NullGauge();
        }

        @Override
        public Gauge declareGauge(String name, Point boundDimensions) {
            return new NullGauge();
        }

        @Override
        public Gauge declareGauge(String name, Optional<Point> boundDimensions, MetricSettings customSettings) {
            return null;
        }

        @Override
        public PointBuilder pointBuilder() {
            return null;
        }

        @Override
        public Bucket getSnapshot() {
            return null;
        }

        @Override
        void addMetricDefinition(String metricName, MetricSettings definition) {
        }

        @Override
        MetricSettings getMetricDefinition(String metricName) {
            return null;
        }
    }

    public static final class MockReceiver
    extends MetricReceiver {
        private final ThreadLocalDirectory<Bucket, Sample> collection;

        private MockReceiver(ThreadLocalDirectory<Bucket, Sample> collection) {
            super(collection, null);
            this.collection = collection;
        }

        public MockReceiver() {
            this((ThreadLocalDirectory<Bucket, Sample>)new ThreadLocalDirectory((ThreadLocalDirectory.Updater)new MetricUpdater()));
        }

        @Override
        public Bucket getSnapshot() {
            Bucket merged = new Bucket();
            for (Bucket b : this.collection.fetch()) {
                merged.merge(b, true);
            }
            return merged;
        }

        public Point point(String dim, String val) {
            return this.pointBuilder().set(dim, val).build();
        }
    }

    private static final class NullGauge
    extends Gauge {
        NullGauge() {
            super(null, null, null);
        }

        @Override
        public void sample(double x) {
        }

        @Override
        public void sample(double x, Point p) {
        }

        @Override
        public PointBuilder builder() {
            return super.builder();
        }
    }

    private static final class NullCounter
    extends Counter {
        NullCounter() {
            super(null, null, null);
        }

        @Override
        public void add() {
        }

        @Override
        public void add(long n) {
        }

        @Override
        public void add(Point p) {
        }

        @Override
        public void add(long n, Point p) {
        }

        @Override
        public PointBuilder builder() {
            return super.builder();
        }
    }
}

