/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.filter;

import com.google.common.collect.Iterables;
import com.yahoo.jdisc.http.Cookie;
import com.yahoo.jdisc.http.filter.DiscFilterResponse;
import com.yahoo.jdisc.http.servlet.ServletResponse;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Response;

class ServletFilterResponse
extends DiscFilterResponse {
    private final ServletResponse parent;

    public ServletFilterResponse(ServletResponse parent) {
        super(parent);
        this.parent = parent;
    }

    ServletResponse getServletResponse() {
        return this.parent;
    }

    @Override
    public void setStatus(int status) {
        this.parent.setStatus(status);
    }

    @Override
    public void setHeader(String name, String value) {
        this.parent.setHeader(name, value);
    }

    @Override
    public void removeHeaders(String name) {
        HttpServletResponse parentResponse = this.parent.getResponse();
        if (!(parentResponse instanceof Response)) {
            throw new UnsupportedOperationException("Cannot remove headers for response of type " + parentResponse.getClass().getName());
        }
        Response jettyResponse = (Response)parentResponse;
        jettyResponse.getHttpFields().remove(name);
    }

    @Override
    public void setHeaders(String name, String value) {
        this.parent.setHeader(name, value);
    }

    @Override
    public void setHeaders(String name, List<String> values) {
        for (String value : values) {
            this.parent.addHeader(name, value);
        }
    }

    @Override
    public void addHeader(String name, String value) {
        this.parent.addHeader(name, value);
    }

    @Override
    public String getHeader(String name) {
        Collection headers = this.parent.getHeaders(name);
        return headers.isEmpty() ? null : (String)Iterables.getLast((Iterable)headers);
    }

    @Override
    public void setCookies(List<Cookie> cookies) {
        this.removeHeaders("Set-Cookie");
        List<String> setCookieHeaders = Cookie.toSetCookieHeaders(cookies);
        setCookieHeaders.forEach(cookie -> this.addHeader("Set-Cookie", (String)cookie));
    }
}

