/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics.simple;

import com.yahoo.metrics.simple.MetricSettings;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.HdrHistogram.DoubleHistogram;

public class UntypedMetric {
    private static final Logger log = Logger.getLogger(UntypedMetric.class.getName());
    private long count = 0L;
    private double current = 0.0;
    private double max;
    private double min;
    private double sum;
    private AssumedType outputFormat = AssumedType.NONE;
    private final DoubleHistogram histogram;
    private final MetricSettings metricSettings;

    UntypedMetric(MetricSettings metricSettings) {
        this.metricSettings = metricSettings;
        this.histogram = metricSettings == null || !metricSettings.isHistogram() ? null : new DoubleHistogram(metricSettings.getSignificantdigits());
    }

    void add(Number x) {
        this.outputFormat = AssumedType.COUNTER;
        this.count += x.longValue();
    }

    void put(Number x) {
        this.outputFormat = AssumedType.GAUGE;
        this.current = x.doubleValue();
        if (this.histogram != null) {
            this.histogram.recordValue(this.current);
        }
        if (this.count > 0L) {
            this.max = Math.max(this.current, this.max);
            this.min = Math.min(this.current, this.min);
            this.sum += this.current;
        } else {
            this.max = this.current;
            this.min = this.current;
            this.sum = this.current;
        }
        ++this.count;
    }

    UntypedMetric pruneData() {
        UntypedMetric pruned = new UntypedMetric(null);
        pruned.outputFormat = this.outputFormat;
        pruned.current = this.current;
        return pruned;
    }

    void merge(UntypedMetric other, boolean otherIsNewer) throws IllegalArgumentException {
        if (this.outputFormat == AssumedType.NONE) {
            this.outputFormat = other.outputFormat;
        }
        if (this.outputFormat != other.outputFormat) {
            throw new IllegalArgumentException("Mismatching output formats: " + this.outputFormat + " and " + other.outputFormat + ".");
        }
        if (this.count > 0L) {
            if (other.count > 0L) {
                this.max = Math.max(other.max, this.max);
                this.min = Math.min(other.min, this.min);
                if (otherIsNewer) {
                    this.current = other.current;
                }
            }
        } else {
            this.max = other.max;
            this.min = other.min;
            this.current = other.current;
        }
        this.count += other.count;
        this.sum += other.sum;
        if (this.histogram != null && other.histogram != null) {
            try {
                this.histogram.add(other.histogram);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                log.log(Level.WARNING, "Had trouble merging histograms: " + e.getMessage());
            }
        }
    }

    public boolean isCounter() {
        return this.outputFormat == AssumedType.COUNTER;
    }

    public long getCount() {
        return this.count;
    }

    public double getLast() {
        return this.current;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getSum() {
        return this.sum;
    }

    MetricSettings getMetricDefinition() {
        return this.metricSettings;
    }

    public DoubleHistogram getHistogram() {
        return this.histogram;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName()).append(": ");
        buf.append("outputFormat=").append((Object)this.outputFormat).append(", ");
        if (this.count > 0L && this.outputFormat == AssumedType.GAUGE) {
            buf.append("max=").append(this.max).append(", ");
            buf.append("min=").append(this.min).append(", ");
            buf.append("sum=").append(this.sum).append(", ");
        }
        if (this.histogram != null) {
            buf.append("histogram=").append(this.histogram).append(", ");
        }
        if (this.metricSettings != null) {
            buf.append("metricSettings=").append(this.metricSettings).append(", ");
        }
        buf.append("current=").append(this.current).append(", ");
        buf.append("count=").append(this.count);
        return buf.toString();
    }

    public static enum AssumedType {
        NONE,
        GAUGE,
        COUNTER;

    }
}

