/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class JerseyBundlesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "72001c383cfb57c9b6a56499dfdb8c82";
    public static final String CONFIG_DEF_NAME = "jersey-bundles";
    public static final String CONFIG_DEF_NAMESPACE = "container.di.config";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.di.config", "bundles[].spec string", "bundles[].packages[] string"};
    private final InnerNodeVector<Bundles> bundles;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public JerseyBundlesConfig(Builder builder) {
        this(builder, true);
    }

    private JerseyBundlesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for jersey-bundles must be initialized: " + builder.__uninitialized);
        }
        this.bundles = Bundles.createVector(builder.bundles);
    }

    public List<Bundles> bundles() {
        return this.bundles;
    }

    public Bundles bundles(int i) {
        return (Bundles)((Object)this.bundles.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(JerseyBundlesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Bundles
    extends InnerNode {
        private final StringNode spec;
        private final LeafNodeVector<String, StringNode> packages;

        public Bundles(Builder builder) {
            this(builder, true);
        }

        private Bundles(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for jersey-bundles.bundles[] must be initialized: " + builder.__uninitialized);
            }
            this.spec = builder.spec == null ? new StringNode() : new StringNode(builder.spec);
            this.packages = new LeafNodeVector(builder.packages, (LeafNode)new StringNode());
        }

        public String spec() {
            return this.spec.value();
        }

        public List<String> packages() {
            return this.packages.asList();
        }

        public String packages(int i) {
            return ((StringNode)this.packages.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Bundles newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("bundles");
            return changes;
        }

        private static InnerNodeVector<Bundles> createVector(List<Builder> builders) {
            ArrayList<Bundles> elems = new ArrayList<Bundles>();
            for (Builder b : builders) {
                elems.add(new Bundles(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("spec"));
            private String spec = null;
            public List<String> packages = new ArrayList<String>();

            public Builder() {
            }

            public Builder(Bundles config) {
                this.spec(config.spec());
                this.packages(config.packages());
            }

            private Builder override(Builder __superior) {
                if (__superior.spec != null) {
                    this.spec(__superior.spec);
                }
                if (!__superior.packages.isEmpty()) {
                    this.packages.addAll(__superior.packages);
                }
                return this;
            }

            public Builder spec(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.spec = __value;
                this.__uninitialized.remove("spec");
                return this;
            }

            public Builder packages(String __value) {
                this.packages.add(__value);
                return this;
            }

            public Builder packages(Collection<String> __values) {
                this.packages.addAll(__values);
                return this;
            }

            public Bundles build() {
                return new Bundles(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Bundles.Builder> bundles = new ArrayList<Bundles.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(JerseyBundlesConfig config) {
            for (Bundles b : config.bundles()) {
                this.bundles(new Bundles.Builder(b));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.bundles.isEmpty()) {
                this.bundles.addAll(__superior.bundles);
            }
            return this;
        }

        public Builder bundles(Bundles.Builder __builder) {
            this.bundles.add(__builder);
            return this;
        }

        public Builder bundles(List<Bundles.Builder> __builders) {
            this.bundles = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return JerseyBundlesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return JerseyBundlesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return JerseyBundlesConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public JerseyBundlesConfig build() {
            return new JerseyBundlesConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

