/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

public final class Prefix
implements Comparable<Prefix> {
    public final String prefix;
    public final String[] elements;
    public final String handler;

    public Prefix(String prefix, String handler) {
        this.prefix = prefix;
        this.elements = prefix.split("/");
        this.handler = handler;
    }

    public Prefix(String prefix) {
        this(prefix, null);
    }

    public boolean hasAnyCommonPrefix(String router) {
        return router.codePointAt(0) == this.prefix.codePointAt(0);
    }

    @Override
    public int compareTo(Prefix other) {
        return this.prefix.compareTo(other.prefix);
    }

    public boolean matches(String path) {
        String[] pathElements = path.split("/");
        if (pathElements.length < this.elements.length) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].equals(pathElements[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.prefix + ": " + this.handler;
    }
}

