/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;

class SimpleConcurrentIdentityHashMap<K, V> {
    private final ConcurrentMap<IdentityKey<K>, V> wrappedMap = new ConcurrentHashMap<IdentityKey<K>, V>();

    SimpleConcurrentIdentityHashMap() {
    }

    Optional<V> get(K key) {
        return Optional.ofNullable(this.wrappedMap.get(SimpleConcurrentIdentityHashMap.identityKey(key)));
    }

    Optional<V> remove(K key) {
        return Optional.ofNullable(this.wrappedMap.remove(SimpleConcurrentIdentityHashMap.identityKey(key)));
    }

    void put(K key, V value) {
        this.wrappedMap.put(SimpleConcurrentIdentityHashMap.identityKey(key), value);
    }

    V computeIfAbsent(K key, Supplier<V> supplier) {
        return (V)this.wrappedMap.computeIfAbsent(SimpleConcurrentIdentityHashMap.identityKey(key), (? super K ignored) -> supplier.get());
    }

    V computeIfAbsent(K key, Function<K, V> factory) {
        return (V)this.wrappedMap.computeIfAbsent(SimpleConcurrentIdentityHashMap.identityKey(key), (? super K k) -> factory.apply(k.instance));
    }

    private static <K> IdentityKey<K> identityKey(K key) {
        return IdentityKey.of(key);
    }

    private static class IdentityKey<K> {
        final K instance;

        IdentityKey(K instance) {
            this.instance = instance;
        }

        static <K> IdentityKey<K> of(K instance) {
            return new IdentityKey<K>(instance);
        }

        public int hashCode() {
            return System.identityHashCode(this.instance);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IdentityKey)) {
                return false;
            }
            IdentityKey other = (IdentityKey)obj;
            return this.instance == other.instance;
        }
    }
}

