/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di.config;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.yahoo.component.ComponentId;
import com.yahoo.container.di.config.JerseyBundlesConfig;
import com.yahoo.container.di.config.JerseyInjectionConfig;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Version;

public class RestApiContext {
    private final List<BundleInfo> bundles = new ArrayList<BundleInfo>();
    private final List<Injectable> injectableComponents = new ArrayList<Injectable>();
    public final JerseyBundlesConfig bundlesConfig;
    public final JerseyInjectionConfig injectionConfig;

    @Inject
    public RestApiContext(JerseyBundlesConfig bundlesConfig, JerseyInjectionConfig injectionConfig) {
        this.bundlesConfig = bundlesConfig;
        this.injectionConfig = injectionConfig;
    }

    public List<BundleInfo> getBundles() {
        return Collections.unmodifiableList(this.bundles);
    }

    public void addBundle(BundleInfo bundle) {
        this.bundles.add(bundle);
    }

    public List<Injectable> getInjectableComponents() {
        return Collections.unmodifiableList(this.injectableComponents);
    }

    public void addInjectableComponent(Key<?> key, ComponentId id, Object component) {
        this.injectableComponents.add(new Injectable(key, id, component));
    }

    public static class BundleInfo {
        public final String symbolicName;
        public final Version version;
        public final String fileLocation;
        public final URL webInfUrl;
        public final ClassLoader classLoader;
        private Set<String> classEntries;

        public BundleInfo(String symbolicName, Version version, String fileLocation, URL webInfUrl, ClassLoader classLoader) {
            this.symbolicName = symbolicName;
            this.version = version;
            this.fileLocation = fileLocation;
            this.webInfUrl = webInfUrl;
            this.classLoader = classLoader;
        }

        public String toString() {
            return this.symbolicName + ":" + this.version;
        }

        public void setClassEntries(Collection<String> entries) {
            this.classEntries = ImmutableSet.copyOf(entries);
        }

        public Set<String> getClassEntries() {
            return this.classEntries;
        }
    }

    public static class Injectable {
        public final Key<?> key;
        public final ComponentId id;
        public final Object instance;

        public Injectable(Key<?> key, ComponentId id, Object instance) {
            this.key = key;
            this.id = id;
            this.instance = instance;
        }

        public String toString() {
            return this.id.toString();
        }
    }
}

