/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.di.componentgraph.core;

import com.google.inject.Key;
import com.yahoo.component.ComponentId;
import com.yahoo.config.ConfigInstance;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.container.di.componentgraph.core.ComponentNode;
import com.yahoo.vespa.config.ConfigKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;

public abstract class Node {
    private static final Logger log = Logger.getLogger(Node.class.getName());
    private final ComponentId componentId;
    protected Optional<Object> instance = Optional.empty();
    List<Node> componentsToInject = new ArrayList<Node>();

    public Node(ComponentId componentId) {
        this.componentId = componentId;
    }

    public abstract Key<?> instanceKey();

    public abstract List<Node> usedComponents();

    protected abstract Object newInstance();

    public void constructInstance() {
        if (!this.instance.isPresent()) {
            this.instance = Optional.of(this.newInstance());
        }
    }

    public Object component() {
        this.constructInstance();
        if (this.instance.get() instanceof Provider) {
            Provider provider = (Provider)this.instance.get();
            return provider.get();
        }
        return this.instance.get();
    }

    public abstract Set<ConfigKey<ConfigInstance>> configKeys();

    public void inject(Node component) {
        this.componentsToInject.add(component);
    }

    public void injectAll(Collection<ComponentNode> componentNodes) {
        componentNodes.forEach(this::inject);
    }

    public abstract Class<?> instanceType();

    public abstract Class<?> componentType();

    public abstract String label();

    public String idAndType() {
        String className = this.instanceType().getName();
        if (className.equals(this.componentId.getName())) {
            return "'" + this.componentId + "'";
        }
        return "'" + this.componentId + "' of type '" + className + "'";
    }

    private static boolean equalNodes(Object a, Object b) {
        if (a instanceof Node && b instanceof Node) {
            Node l = (Node)a;
            Node r = (Node)b;
            return l.componentId.equals((Object)r.componentId);
        }
        return a.equals(b);
    }

    public static boolean equalEdges(List<?> edges1, List<?> edges2) {
        Iterator<?> right = edges2.iterator();
        for (Object l : edges1) {
            if (!right.hasNext()) {
                return false;
            }
            Object r = right.next();
            if (Node.equalNodes(l, r)) continue;
            return false;
        }
        return !right.hasNext();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.componentId == null ? 0 : this.componentId.hashCode());
        result = 31 * result + (this.componentsToInject == null ? 0 : this.componentsToInject.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof Node) {
            Node that = (Node)other;
            return this.getClass().equals(that.getClass()) && this.componentId.equals((Object)that.componentId) && this.instanceType().equals(that.instanceType()) && Node.equalEdges(this.usedComponents(), that.usedComponents());
        }
        return false;
    }

    public ComponentId componentId() {
        return this.componentId;
    }

    public Optional<?> constructedInstance() {
        return this.instance;
    }

    protected static ComponentId syntheticComponentId(String className, Object identityObject, ComponentId namespace) {
        String name = className + "_" + System.identityHashCode(identityObject);
        return ComponentId.fromString((String)name).nestInNamespace(namespace);
    }

    public static String packageName(Class<?> componentClass) {
        String fullClassName = componentClass.getName();
        int index = fullClassName.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return fullClassName.substring(0, index);
    }
}

