/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.google.inject.Inject;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.server.jetty.JDiscServerConnector;
import com.yahoo.jdisc.http.server.jetty.JettyConnectionLogger;
import com.yahoo.jdisc.http.server.jetty.SslHandshakeFailedListener;
import com.yahoo.jdisc.http.ssl.SslContextFactoryProvider;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TransportSecurityUtils;
import java.util.Collection;
import java.util.List;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.DetectorConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ConnectorFactory {
    private final ConnectorConfig connectorConfig;
    private final SslContextFactoryProvider sslContextFactoryProvider;

    @Inject
    public ConnectorFactory(ConnectorConfig connectorConfig, SslContextFactoryProvider sslContextFactoryProvider) {
        ConnectorFactory.runtimeConnectorConfigValidation(connectorConfig);
        this.connectorConfig = connectorConfig;
        this.sslContextFactoryProvider = sslContextFactoryProvider;
    }

    private static void runtimeConnectorConfigValidation(ConnectorConfig config) {
        ConnectorFactory.validateProxyProtocolConfiguration(config);
        ConnectorFactory.validateSecureRedirectConfig(config);
    }

    private static void validateProxyProtocolConfiguration(ConnectorConfig config) {
        ConnectorConfig.ProxyProtocol proxyProtocolConfig = config.proxyProtocol();
        if (proxyProtocolConfig.enabled()) {
            boolean tlsMixedModeEnabled;
            boolean bl = tlsMixedModeEnabled = TransportSecurityUtils.getInsecureMixedMode() != MixedMode.DISABLED;
            if (!ConnectorFactory.isSslEffectivelyEnabled(config) || tlsMixedModeEnabled) {
                throw new IllegalArgumentException("Proxy protocol can only be enabled if connector is effectively HTTPS only");
            }
        }
    }

    private static void validateSecureRedirectConfig(ConnectorConfig config) {
        if (config.secureRedirect().enabled() && ConnectorFactory.isSslEffectivelyEnabled(config)) {
            throw new IllegalArgumentException("Secure redirect can only be enabled on connectors without HTTPS");
        }
    }

    public ConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public ServerConnector createConnector(Metric metric, Server server, JettyConnectionLogger connectionLogger) {
        JDiscServerConnector connector = new JDiscServerConnector(this.connectorConfig, metric, server, connectionLogger, (ConnectionFactory[])this.createConnectionFactories(metric).toArray(ConnectionFactory[]::new));
        connector.setPort(this.connectorConfig.listenPort());
        connector.setName(this.connectorConfig.name());
        connector.setAcceptQueueSize(this.connectorConfig.acceptQueueSize());
        connector.setReuseAddress(this.connectorConfig.reuseAddress());
        connector.setIdleTimeout((long)(this.connectorConfig.idleTimeout() * 1000.0));
        return connector;
    }

    private List<ConnectionFactory> createConnectionFactories(Metric metric) {
        if (!ConnectorFactory.isSslEffectivelyEnabled(this.connectorConfig)) {
            return List.of(this.newHttp1ConnectionFactory());
        }
        if (this.connectorConfig.ssl().enabled()) {
            return this.connectionFactoriesForHttps(metric);
        }
        if (TransportSecurityUtils.isTransportSecurityEnabled()) {
            switch (TransportSecurityUtils.getInsecureMixedMode()) {
                case TLS_CLIENT_MIXED_SERVER: 
                case PLAINTEXT_CLIENT_MIXED_SERVER: {
                    return this.connectionFactoriesForHttpsMixedMode(metric);
                }
                case DISABLED: {
                    return this.connectionFactoriesForHttps(metric);
                }
            }
            throw new IllegalStateException();
        }
        return List.of(this.newHttp1ConnectionFactory());
    }

    private List<ConnectionFactory> connectionFactoriesForHttps(Metric metric) {
        ConnectorConfig.ProxyProtocol proxyProtocolConfig = this.connectorConfig.proxyProtocol();
        HttpConnectionFactory http1Factory = this.newHttp1ConnectionFactory();
        if (this.connectorConfig.http2Enabled()) {
            HTTP2ServerConnectionFactory http2Factory = this.newHttp2ConnectionFactory();
            ALPNServerConnectionFactory alpnFactory = this.newAlpnConnectionFactory(List.of(http1Factory, http2Factory), (ConnectionFactory)http1Factory);
            SslConnectionFactory sslFactory = this.newSslConnectionFactory(metric, (ConnectionFactory)alpnFactory);
            if (proxyProtocolConfig.enabled()) {
                if (proxyProtocolConfig.mixedMode()) {
                    ProxyConnectionFactory proxyProtocolFactory = this.newProxyProtocolConnectionFactory((ConnectionFactory)alpnFactory);
                    DetectorConnectionFactory detectorFactory = this.newDetectorConnectionFactory(new ConnectionFactory.Detecting[]{sslFactory, proxyProtocolFactory});
                    return List.of(detectorFactory, proxyProtocolFactory, sslFactory, alpnFactory, http1Factory, http2Factory);
                }
                ProxyConnectionFactory proxyProtocolFactory = this.newProxyProtocolConnectionFactory((ConnectionFactory)alpnFactory);
                return List.of(proxyProtocolFactory, sslFactory, alpnFactory, http1Factory, http2Factory);
            }
            return List.of(sslFactory, alpnFactory, http1Factory, http2Factory);
        }
        SslConnectionFactory sslFactory = this.newSslConnectionFactory(metric, (ConnectionFactory)http1Factory);
        if (proxyProtocolConfig.enabled()) {
            if (proxyProtocolConfig.mixedMode()) {
                ProxyConnectionFactory proxyProtocolFactory = this.newProxyProtocolConnectionFactory((ConnectionFactory)sslFactory);
                DetectorConnectionFactory detectorFactory = this.newDetectorConnectionFactory(new ConnectionFactory.Detecting[]{sslFactory, proxyProtocolFactory});
                return List.of(detectorFactory, proxyProtocolFactory, sslFactory, http1Factory);
            }
            ProxyConnectionFactory proxyProtocolFactory = this.newProxyProtocolConnectionFactory((ConnectionFactory)sslFactory);
            return List.of(proxyProtocolFactory, sslFactory, http1Factory);
        }
        return List.of(sslFactory, http1Factory);
    }

    private List<ConnectionFactory> connectionFactoriesForHttpsMixedMode(Metric metric) {
        HttpConnectionFactory httpFactory = this.newHttp1ConnectionFactory();
        SslConnectionFactory sslFactory = this.newSslConnectionFactory(metric, (ConnectionFactory)httpFactory);
        DetectorConnectionFactory detectorFactory = this.newDetectorConnectionFactory(new ConnectionFactory.Detecting[]{sslFactory});
        return List.of(detectorFactory, httpFactory, sslFactory);
    }

    private HttpConfiguration newHttpConfiguration() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendDateHeader(true);
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendXPoweredBy(false);
        httpConfig.setHeaderCacheSize(this.connectorConfig.headerCacheSize());
        httpConfig.setOutputBufferSize(this.connectorConfig.outputBufferSize());
        httpConfig.setRequestHeaderSize(this.connectorConfig.requestHeaderSize());
        httpConfig.setResponseHeaderSize(this.connectorConfig.responseHeaderSize());
        if (ConnectorFactory.isSslEffectivelyEnabled(this.connectorConfig)) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        }
        return httpConfig;
    }

    private HttpConnectionFactory newHttp1ConnectionFactory() {
        return new HttpConnectionFactory(this.newHttpConfiguration());
    }

    private HTTP2ServerConnectionFactory newHttp2ConnectionFactory() {
        return new HTTP2ServerConnectionFactory(this.newHttpConfiguration());
    }

    private SslConnectionFactory newSslConnectionFactory(Metric metric, ConnectionFactory wrappedFactory) {
        SslContextFactory ctxFactory = this.sslContextFactoryProvider.getInstance(this.connectorConfig.name(), this.connectorConfig.listenPort());
        SslConnectionFactory connectionFactory = new SslConnectionFactory(ctxFactory, wrappedFactory.getProtocol());
        connectionFactory.addBean((Object)new SslHandshakeFailedListener(metric, this.connectorConfig.name(), this.connectorConfig.listenPort()));
        return connectionFactory;
    }

    private ALPNServerConnectionFactory newAlpnConnectionFactory(Collection<ConnectionFactory> alternatives, ConnectionFactory defaultFactory) {
        String[] protocols = (String[])alternatives.stream().map(ConnectionFactory::getProtocol).toArray(String[]::new);
        ALPNServerConnectionFactory factory = new ALPNServerConnectionFactory(protocols);
        factory.setDefaultProtocol(defaultFactory.getProtocol());
        return factory;
    }

    private DetectorConnectionFactory newDetectorConnectionFactory(ConnectionFactory.Detecting ... alternatives) {
        return new DetectorConnectionFactory(alternatives);
    }

    private ProxyConnectionFactory newProxyProtocolConnectionFactory(ConnectionFactory wrappedFactory) {
        return new ProxyConnectionFactory(wrappedFactory.getProtocol());
    }

    private static boolean isSslEffectivelyEnabled(ConnectorConfig config) {
        return config.ssl().enabled() || config.implicitTlsEnabled() && TransportSecurityUtils.isTransportSecurityEnabled();
    }
}

