/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.servlet;

import com.google.common.collect.ImmutableMap;
import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.http.Cookie;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.server.jetty.HttpServletRequestUtils;
import com.yahoo.jdisc.http.servlet.ServletOrJdiscHttpRequest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ServletRequest
extends HttpServletRequestWrapper
implements ServletOrJdiscHttpRequest {
    public static final String JDISC_REQUEST_PRINCIPAL = "jdisc.request.principal";
    public static final String JDISC_REQUEST_X509CERT = "jdisc.request.X509Certificate";
    public static final String JDISC_REQUEST_CHAIN = "jdisc.request.chain";
    public static final String JDISC_RESPONSE_CHAIN = "jdisc.response.chain";
    public static final String SERVLET_REQUEST_X509CERT = "javax.servlet.request.X509Certificate";
    public static final String SERVLET_REQUEST_SSL_SESSION_ID = "javax.servlet.request.ssl_session_id";
    public static final String SERVLET_REQUEST_CIPHER_SUITE = "javax.servlet.request.cipher_suite";
    private final HttpServletRequest request;
    private final HeaderFields headerFields;
    private final Set<String> removedHeaders = new HashSet<String>();
    private final Map<String, Object> context = new HashMap<String, Object>();
    private final Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private final long connectedAt;
    private URI uri;
    private String remoteHostAddress;
    private String remoteHostName;
    private int remotePort;

    public ServletRequest(HttpServletRequest request, URI uri) {
        super(request);
        this.request = request;
        this.uri = uri;
        super.getParameterMap().forEach((key, values) -> this.parameters.put((String)key, Arrays.asList(values)));
        this.remoteHostAddress = request.getRemoteAddr();
        this.remoteHostName = request.getRemoteHost();
        this.remotePort = request.getRemotePort();
        this.connectedAt = HttpServletRequestUtils.getConnection(request).getCreatedTimeStamp();
        this.headerFields = new HeaderFields();
        Enumeration parentHeaders = request.getHeaderNames();
        while (parentHeaders.hasMoreElements()) {
            String name = (String)parentHeaders.nextElement();
            Enumeration values2 = request.getHeaders(name);
            while (values2.hasMoreElements()) {
                this.headerFields.add(name, (String)values2.nextElement());
            }
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap parameterMap = new HashMap();
        this.parameters().forEach((key, values) -> parameterMap.put(key, values.toArray(new String[values.size()])));
        return ImmutableMap.copyOf(parameterMap);
    }

    public String getParameter(String name) {
        return this.parameters().containsKey(name) ? this.parameters().get(name).get(0) : null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        List<String> values = this.parameters().get(name);
        return values != null ? values.toArray(new String[values.size()]) : null;
    }

    @Override
    public void copyHeaders(HeaderFields target) {
        target.addAll((Map)this.headerFields);
    }

    public Enumeration<String> getHeaders(String name) {
        if (this.removedHeaders.contains(name)) {
            return null;
        }
        List headerFields = this.headerFields.get((Object)name);
        return headerFields == null || headerFields.isEmpty() ? super.getHeaders(name) : Collections.enumeration(headerFields);
    }

    public String getHeader(String name) {
        if (this.removedHeaders.contains(name)) {
            return null;
        }
        String headerField = this.headerFields.getFirst(name);
        return headerField != null ? headerField : super.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        HashSet names = new HashSet(Collections.list(super.getHeaderNames()));
        names.addAll(this.headerFields.keySet());
        names.removeAll(this.removedHeaders);
        return Collections.enumeration(names);
    }

    public void addHeader(String name, String value) {
        this.headerFields.add(name, value);
        this.removedHeaders.remove(name);
    }

    public void setHeaders(String name, String value) {
        this.headerFields.put(name, value);
        this.removedHeaders.remove(name);
    }

    public void setHeaders(String name, List<String> values) {
        this.headerFields.put(name, values);
        this.removedHeaders.remove(name);
    }

    public void removeHeaders(String name) {
        this.headerFields.remove((Object)name);
        this.removedHeaders.add(name);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public HttpRequest.Version getVersion() {
        String protocol = this.request.getProtocol();
        try {
            return HttpRequest.Version.fromString(protocol);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new RuntimeException("Servlet request protocol '" + protocol + "' could not be mapped to a JDisc http version.", e);
        }
    }

    @Override
    public String getRemoteHostAddress() {
        return this.remoteHostAddress;
    }

    @Override
    public String getRemoteHostName() {
        return this.remoteHostName;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public void setRemoteAddress(SocketAddress remoteAddress) {
        if (!(remoteAddress instanceof InetSocketAddress)) {
            throw new RuntimeException("Unknown SocketAddress class: " + this.remoteHostAddress.getClass().getName());
        }
        this.remoteHostAddress = ((InetSocketAddress)remoteAddress).getAddress().getHostAddress();
        this.remoteHostName = ((InetSocketAddress)remoteAddress).getAddress().getHostName();
        this.remotePort = ((InetSocketAddress)remoteAddress).getPort();
    }

    @Override
    public Map<String, Object> context() {
        return this.context;
    }

    public javax.servlet.http.Cookie[] getCookies() {
        return (javax.servlet.http.Cookie[])this.decodeCookieHeader().stream().map(jdiscCookie -> new javax.servlet.http.Cookie(jdiscCookie.getName(), jdiscCookie.getValue())).toArray(javax.servlet.http.Cookie[]::new);
    }

    @Override
    public List<Cookie> decodeCookieHeader() {
        Enumeration<String> cookies = this.getHeaders("Cookie");
        if (cookies == null) {
            return Collections.emptyList();
        }
        LinkedList<Cookie> ret = new LinkedList<Cookie>();
        while (cookies.hasMoreElements()) {
            ret.addAll(Cookie.fromCookieHeader(cookies.nextElement()));
        }
        return ret;
    }

    @Override
    public void encodeCookieHeader(List<Cookie> cookies) {
        this.setHeaders("Cookie", Cookie.toCookieHeader(cookies));
    }

    @Override
    public long getConnectedAt(TimeUnit unit) {
        return unit.convert(this.connectedAt, TimeUnit.MILLISECONDS);
    }

    public Principal getUserPrincipal() {
        return (Principal)this.request.getAttribute(JDISC_REQUEST_PRINCIPAL);
    }

    public void setUserPrincipal(Principal principal) {
        this.request.setAttribute(JDISC_REQUEST_PRINCIPAL, (Object)principal);
    }
}

